/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.text.MessageFormat;
import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBConcatExpr
extends DBColumnExpr {
    private static final long serialVersionUID = 1L;
    protected final DBColumnExpr left;
    protected final Object right;

    public DBConcatExpr(DBColumnExpr left, Object right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.left.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return DataType.TEXT;
    }

    @Override
    public String getName() {
        String name = this.left.getName();
        if (this.right instanceof DBColumnExpr) {
            name = name + "_";
            name = name + ((DBColumnExpr)this.right).getName();
        }
        return name;
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        elem.setAttribute("function", "concat");
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, flags);
        }
        return elem;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.left.addReferencedColumns(list);
        if (this.right instanceof DBExpr) {
            ((DBExpr)this.right).addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        String template = this.getDatabase().getDriver().getSQLPhrase(8);
        context &= 0xFFFFFFFFFFFFFFF7L;
        int sep = template.indexOf(63);
        if (sep >= 0) {
            buf.append(template.substring(0, sep));
            this.left.addSQL(buf, context);
            String value = this.getObjectValue(this.getDataType(), this.right, context, ", ");
            buf.append(MessageFormat.format(template.substring(sep + 1), value));
        } else {
            this.left.addSQL(buf, context);
            buf.append(template);
            buf.append(this.getObjectValue(this.getDataType(), this.right, context, template));
        }
    }

    public boolean equals(Object other) {
        if (other instanceof DBConcatExpr) {
            return this.left.equals(((DBConcatExpr)other).left) && this.right.equals(((DBConcatExpr)other).right);
        }
        return false;
    }
}

