/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCaseExpr
extends DBColumnExpr {
    private static final long serialVersionUID = 1L;
    private final DBCompareExpr compExpr;
    private final DBColumnExpr trueExpr;
    private final DBColumnExpr elseExpr;

    public DBCaseExpr(DBCompareExpr compExpr, DBColumnExpr trueExpr, DBColumnExpr elseExpr) {
        this.compExpr = compExpr;
        this.trueExpr = trueExpr;
        this.elseExpr = elseExpr;
    }

    @Override
    public DBDatabase getDatabase() {
        return this.trueExpr.getDatabase();
    }

    @Override
    public DataType getDataType() {
        return this.trueExpr.getDataType();
    }

    @Override
    public String getName() {
        return this.trueExpr.getName();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this.trueExpr.getUpdateColumn();
    }

    @Override
    public boolean isAggregate() {
        return this.trueExpr.isAggregate();
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        this.trueExpr.addReferencedColumns(list);
        this.compExpr.addReferencedColumns(list);
        if (this.elseExpr != null) {
            this.elseExpr.addReferencedColumns(list);
        }
    }

    @Override
    public void addSQL(StringBuilder sql, long context) {
        sql.append("CASE WHEN ");
        this.compExpr.addSQL(sql, context &= 0xFFFFFFFFFFFFFFF7L);
        sql.append(" THEN ");
        this.trueExpr.addSQL(sql, context);
        sql.append(" ELSE ");
        if (this.elseExpr != null) {
            this.elseExpr.addSQL(sql, context);
        } else {
            sql.append("NULL");
        }
        sql.append(" END");
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, flags);
        }
        elem.setAttribute("function", "case");
        return elem;
    }
}

