/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.exceptions;

import java.sql.SQLException;
import org.apache.empire.commons.ErrorType;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.exceptions.InternalSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFailedException
extends InternalSQLException {
    private static final Logger log = LoggerFactory.getLogger(QueryFailedException.class);
    private static final long serialVersionUID = 1L;
    public static final ErrorType errorType = new ErrorType("error.db.queryFailed", "Error executing query {0}.\r\nNative error is: {1}");

    public QueryFailedException(DBObject obj, String sqlCmd, SQLException cause) {
        super(errorType, new String[]{sqlCmd, QueryFailedException.messageFromSQLException(QueryFailedException.driverFromObject(obj), cause)}, cause);
    }

    protected void log() {
        if (log.isErrorEnabled()) {
            log.error(this.getMessage());
        } else {
            super.log();
        }
    }
}

