/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.exceptions;

import java.sql.SQLException;
import org.apache.empire.commons.ErrorType;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBObject;
import org.apache.empire.exceptions.EmpireException;

public class InternalSQLException
extends EmpireException {
    private static final long serialVersionUID = 1L;
    public static final ErrorType errorType = new ErrorType("error.db.sqlException", "The database operation failed. Native error is: {0}");

    protected static String messageFromSQLException(DBDatabaseDriver driver, SQLException sqle) {
        return driver != null ? driver.extractErrorMessage(sqle) : sqle.getMessage();
    }

    protected static DBDatabaseDriver driverFromObject(DBObject obj) {
        return obj.getDatabase() != null ? obj.getDatabase().getDriver() : (DBDatabaseDriver)null;
    }

    public InternalSQLException(DBDatabaseDriver driver, SQLException cause) {
        super(errorType, new String[]{InternalSQLException.messageFromSQLException(driver, cause)}, cause);
    }

    public InternalSQLException(DBObject obj, SQLException cause) {
        this(InternalSQLException.driverFromObject(obj), cause);
    }

    protected InternalSQLException(ErrorType type, String[] params, SQLException cause) {
        super(type, params, cause);
    }
}

