/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.empire.commons.Options;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public abstract class DBView
extends DBRowSet {
    private static final long serialVersionUID = 1L;
    private static AtomicInteger viewCount = new AtomicInteger(0);
    private String name;
    private String alias;
    private boolean updateable;
    private Boolean quoteName = null;

    public DBView(String name, DBDatabase db, boolean isUpdateable) {
        super(db);
        if (db != null && name != null) {
            db.addView(this);
        }
        this.name = name;
        this.alias = "v" + String.valueOf(viewCount.incrementAndGet());
        this.updateable = isUpdateable;
    }

    public DBView(String name, DBDatabase db) {
        this(name, db, false);
    }

    protected void setKeyColumns(DBViewColumn[] keyColumns) {
        if (keyColumns != null) {
            this.primaryKey = new DBIndex(null, 2, keyColumns);
        }
    }

    protected void setKeyColumn(DBViewColumn keyColumn) {
        if (keyColumn != null) {
            this.setKeyColumns(new DBViewColumn[]{keyColumn});
        } else {
            this.setKeyColumns(null);
        }
    }

    public abstract DBCommandExpr createCommand();

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        String schema = this.db.getSchema();
        return schema != null ? schema + "." + this.name : this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isUpdateable() {
        return this.updateable;
    }

    protected void addColumn(DBViewColumn col) {
        if (col == null || col.getRowSet() != this) {
            throw new InvalidArgumentException("col", col);
        }
        if (this.getColumn(col.getName()) != null) {
            throw new ItemExistsException((Object)col.getName());
        }
        this.columns.add(col);
    }

    protected final DBViewColumn addColumn(String columnName, DataType dataType) {
        return new DBViewColumn(this, columnName, new DBValueExpr(this.db, null, dataType));
    }

    protected final DBViewColumn addColumn(String columnName, DBColumnExpr columnExpr) {
        return new DBViewColumn(this, columnName, columnExpr);
    }

    protected final DBViewColumn addColumn(DBTableColumn sourceColumn) {
        return new DBViewColumn(this, sourceColumn.getName(), sourceColumn);
    }

    public DBViewColumn findViewColumn(DBColumnExpr expr) {
        for (int i = 0; i < this.columns.size(); ++i) {
            DBViewColumn vc = (DBViewColumn)this.columns.get(i);
            if (!vc.expr.equals(expr)) continue;
            return vc;
        }
        return null;
    }

    public void addSQL(StringBuilder buf, long context) {
        if ((context & 1L | 2L) != 0L) {
            DBDatabaseDriver driver = this.getDatabase().getDriver();
            if (this.quoteName == null) {
                this.quoteName = driver.detectQuoteName(this.name);
            }
            this.db.appendQualifiedName(buf, this.name, this.quoteName);
        }
        if ((context & 8L) != 0L && this.alias != null) {
            buf.append(this.getRenameTablePhrase());
            buf.append(this.alias);
        }
    }

    public void updateRecord(DBRecord rec, Connection conn) {
        if (!this.updateable) {
            throw new NotSupportedException(this, "updateRecord");
        }
        super.updateRecord(rec, conn);
    }

    public void createRecord(DBRecord rec, Connection conn) {
        throw new NotSupportedException(this, "createRecord");
    }

    public void deleteRecord(Object[] keys, Connection conn) {
        throw new NotSupportedException(this, "deleteRecord");
    }

    public static class DBViewColumn
    extends DBColumn {
        private static final long serialVersionUID = 1L;
        protected final DBColumnExpr expr;
        protected final DBColumn updateColumn;

        protected DBViewColumn(DBView view, String name, DBColumnExpr expr) {
            super(view, name);
            this.expr = expr;
            this.updateColumn = expr.getUpdateColumn();
            if (view != null) {
                view.addColumn(this);
            }
        }

        public DBColumnExpr getSourceColumnExpr() {
            return this.expr;
        }

        public DBView getView() {
            return (DBView)this.getRowSet();
        }

        public DataType getDataType() {
            return this.expr.getDataType();
        }

        public double getSize() {
            if (this.updateColumn == null) {
                return 0.0;
            }
            return this.updateColumn.getSize();
        }

        public boolean isAutoGenerated() {
            if (this.updateColumn == null) {
                return false;
            }
            return this.updateColumn.isAutoGenerated();
        }

        public boolean isReadOnly() {
            if (!this.getView().isUpdateable()) {
                return true;
            }
            if (this.attributes != null && this.attributes.contains("readonly")) {
                return true;
            }
            return this.isAutoGenerated();
        }

        public boolean isRequired() {
            if (!this.getView().isUpdateable()) {
                return false;
            }
            if (this.updateColumn == null) {
                return false;
            }
            return this.updateColumn.isRequired();
        }

        public void validate(Object value) {
            if (this.updateColumn == null) {
                return;
            }
            this.updateColumn.validate(value);
        }

        public Object getAttribute(String name) {
            if (this.attributes != null && this.attributes.contains(name)) {
                return this.attributes.get(name);
            }
            if (this.updateColumn == null) {
                return null;
            }
            return this.updateColumn.getAttribute(name);
        }

        public Options getOptions() {
            if (this.options != null) {
                return this.options;
            }
            if (this.updateColumn == null) {
                return null;
            }
            return this.updateColumn.getOptions();
        }

        public Element addXml(Element parent, long flags) {
            Options fieldOptions;
            double size;
            Element elem = XMLUtil.addElement(parent, "column");
            elem.setAttribute("name", this.name);
            if (this.updateColumn != null) {
                elem.setAttribute("source", this.updateColumn.getFullName());
            }
            if ((size = this.getSize()) > 0.0) {
                elem.setAttribute("size", String.valueOf(size));
            }
            if (this.attributes != null) {
                this.attributes.addXml(elem, flags);
            }
            if ((fieldOptions = this.getOptions()) != null) {
                fieldOptions.addXml(elem, flags);
            }
            return elem;
        }
    }
}

