/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.empire.commons.Attributes;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.DataMode;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.db.exceptions.FieldNotNullException;
import org.apache.empire.db.exceptions.FieldValueTooLongException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DBTableColumn
extends DBColumn {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBTableColumn.class);
    protected DataType type;
    protected double size;
    protected DataMode dataMode;
    protected Object defValue;

    public DBTableColumn(DBTable table, DataType type, String name, double size, DataMode dataMode, Object defValue) {
        super(table, name);
        if (type == DataType.AUTOINC && dataMode != DataMode.AutoGenerated) {
            dataMode = DataMode.AutoGenerated;
        }
        if (type == DataType.INTEGER && dataMode == DataMode.AutoGenerated) {
            type = DataType.AUTOINC;
        }
        this.type = type;
        this.dataMode = dataMode;
        this.defValue = defValue;
        this.attributes = new Attributes();
        this.options = null;
        this.setSize(size);
        if (table != null) {
            table.addColumn(this);
        }
    }

    protected DBTableColumn(DBTable newTable, DBTableColumn other) {
        super(newTable, other.name);
        this.type = other.type;
        this.size = other.size;
        this.dataMode = other.dataMode;
        this.defValue = other.defValue;
        this.attributes = new Attributes();
        this.attributes.addAll(other.attributes);
        this.options = other.options;
        if (newTable != null) {
            newTable.addColumn(this);
        }
    }

    public Object getDefaultValue() {
        return this.defValue;
    }

    public void setDefaultValue(Object defValue) {
        this.defValue = defValue;
    }

    public Object getRecordDefaultValue(Connection conn) {
        if (this.rowset == null) {
            return this.defValue;
        }
        DBDatabase db = this.rowset.getDatabase();
        if (this.isAutoGenerated()) {
            if (conn == null) {
                return null;
            }
            DBDatabaseDriver driver = db.getDriver();
            return driver.getColumnAutoValue(db, this, conn);
        }
        return this.defValue;
    }

    public DataType getDataType() {
        return this.type;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        if (size < 0.0) {
            if (!this.isTextColumn()) {
                throw new InvalidArgumentException("size", size);
            }
            this.setAttribute("singleByteChars", Boolean.TRUE);
            size = Math.abs(size);
        } else if (this.attributes != null && this.attributes.contains("singleByteChars")) {
            this.attributes.remove("singleByteChars");
        }
        this.size = size;
    }

    public boolean isRequired() {
        return this.dataMode == DataMode.NotNull;
    }

    public boolean isAutoGenerated() {
        return this.dataMode == DataMode.AutoGenerated;
    }

    public boolean isSingleByteChars() {
        if (this.attributes == null || !this.attributes.contains("singleByteChars")) {
            return false;
        }
        return ObjectUtils.getBoolean(this.attributes.get("singleByteChars"));
    }

    public void setSingleByteChars(boolean singleByteChars) {
        if (!this.isTextColumn()) {
            throw new NotSupportedException(this, "setSingleByteChars");
        }
        this.setAttribute("singleByteChars", singleByteChars);
    }

    public void setRequired(boolean required) {
        if (this.isAutoGenerated()) {
            throw new PropertyReadOnlyException("required");
        }
        this.dataMode = required ? DataMode.NotNull : DataMode.Nullable;
    }

    public boolean isReadOnly() {
        if (this.attributes != null && this.attributes.contains("readonly")) {
            return true;
        }
        return this.dataMode == DataMode.ReadOnly || this.dataMode == DataMode.AutoGenerated;
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.setAttribute("readonly", Boolean.TRUE);
        } else if (this.attributes != null) {
            this.attributes.remove("readonly");
        }
    }

    public void validate(Object value) {
        if (this.isRequired() && (value == null || value.toString().length() < 1)) {
            throw new FieldNotNullException(this);
        }
        switch (this.type) {
            case DATE: 
            case DATETIME: {
                if (value == null || value instanceof Date || value.equals(DBDatabase.SYSDATE)) break;
                try {
                    String val = value.toString();
                    if (val.length() <= 0) break;
                    SimpleDateFormat sdFormat = new SimpleDateFormat("dd-MM-yyyy");
                    sdFormat.setLenient(true);
                    sdFormat.parse(value.toString());
                    break;
                }
                catch (ParseException e) {
                    log.error("checkValue failed: " + e.toString() + " column=" + this.getName() + " value=" + value);
                    throw new FieldIllegalValueException(this, String.valueOf(value), (Throwable)e);
                }
            }
            case DECIMAL: 
            case FLOAT: {
                if (value == null || value instanceof Number) break;
                try {
                    String val = value.toString();
                    if (val.length() <= 0) break;
                    Double.parseDouble(val);
                    break;
                }
                catch (NumberFormatException e) {
                    log.error("checkValue exception: " + e.toString() + " column=" + this.getName() + " value=" + value);
                    throw new FieldIllegalValueException(this, String.valueOf(value), (Throwable)e);
                }
            }
            case INTEGER: {
                if (value == null || value instanceof Number) break;
                try {
                    String val = value.toString();
                    if (val.length() <= 0) break;
                    Long.parseLong(val);
                    break;
                }
                catch (NumberFormatException e) {
                    log.error("checkValue exception: " + e.toString() + " column=" + this.getName() + " value=" + String.valueOf(value));
                    throw new FieldIllegalValueException(this, String.valueOf(value), (Throwable)e);
                }
            }
            case TEXT: 
            case CHAR: {
                if (value == null || !((double)value.toString().length() > this.size)) break;
                throw new FieldValueTooLongException(this);
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug("No column validation has been implemented for data type " + (Object)((Object)this.type));
            }
        }
    }

    public DBRelation.DBReference referenceOn(DBTableColumn target) {
        return new DBRelation.DBReference(this, target);
    }

    public Element addXml(Element parent, long flags) {
        int keyIndex;
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.name);
        DBIndex primaryKey = ((DBTable)this.rowset).getPrimaryKey();
        if (primaryKey != null && (keyIndex = ((DBTable)this.rowset).getPrimaryKey().getColumnPos(this)) >= 0) {
            elem.setAttribute("key", String.valueOf(keyIndex + 1));
        }
        if (this.size > 0.0) {
            elem.setAttribute("size", String.valueOf((int)this.size));
            if (this.getDataType() == DataType.DECIMAL) {
                elem.setAttribute("decimals", String.valueOf((int)(this.size * 10.0) % 10));
            }
        }
        if (this.isRequired()) {
            elem.setAttribute("mandatory", String.valueOf(Boolean.TRUE));
        }
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        if (this.options != null) {
            this.options.addXml(elem, flags);
        }
        return elem;
    }
}

