/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.exceptions.InternalSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSQLScript
implements Iterable<String> {
    private static final Logger log = LoggerFactory.getLogger(DBSQLScript.class);
    private static final String DEFAULT_COMMAND_SEPARATOR = ";\r\n\r\n";
    protected String commandSeparator = ";\r\n\r\n";
    protected ArrayList<String> sqlCmdList = new ArrayList();

    public DBSQLScript() {
    }

    public DBSQLScript(String commandSeparator) {
        this.commandSeparator = commandSeparator;
    }

    public void addStmt(String sql) {
        this.sqlCmdList.add(sql);
    }

    public final void addStmt(StringBuilder sql) {
        this.addStmt(sql.toString());
        sql.setLength(0);
    }

    public int getCount() {
        return this.sqlCmdList.size();
    }

    public String getStmt(int i) {
        return this.sqlCmdList.get(i);
    }

    public void clear() {
        this.sqlCmdList.clear();
    }

    public void run(DBDatabaseDriver driver, Connection conn, boolean ignoreErrors) {
        log.debug("Running script containing " + String.valueOf(this.getCount()) + " statements.");
        for (String stmt : this.sqlCmdList) {
            try {
                log.debug("Executing: " + stmt);
                driver.executeSQL(stmt, null, conn, null);
            }
            catch (SQLException e) {
                log.error(e.toString(), (Throwable)e);
                if (!ignoreErrors) {
                    throw new InternalSQLException(driver, e);
                }
                log.debug("Ignoring error. Continuing with script...");
            }
        }
        log.debug("Script completed.");
    }

    public void run(DBDatabaseDriver driver, Connection conn) {
        this.run(driver, conn, false);
    }

    @Override
    public Iterator<String> iterator() {
        return this.sqlCmdList.iterator();
    }

    public String toString() {
        StringBuilder script = new StringBuilder();
        for (String stmt : this.sqlCmdList) {
            script.append(stmt);
            script.append(this.commandSeparator);
        }
        return script.toString();
    }
}

