/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBObject;
import org.apache.empire.exceptions.BeanPropertySetException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBRecordData
extends DBObject
implements RecordData {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DBRecordData.class);

    @Override
    public abstract int getFieldCount();

    @Override
    public abstract int getFieldIndex(ColumnExpr var1);

    @Override
    public abstract int getFieldIndex(String var1);

    @Override
    public abstract ColumnExpr getColumnExpr(int var1);

    public abstract int addColumnDesc(Element var1);

    public abstract int addRowValues(Element var1);

    public abstract Document getXmlDocument();

    public abstract void close();

    @Override
    public abstract Object getValue(int var1);

    @Override
    public final Object getValue(ColumnExpr column) {
        int index = this.getFieldIndex(column);
        if (index < 0) {
            throw new ItemNotFoundException((Object)column.getName());
        }
        return this.getValue(index);
    }

    public int getInt(int index) {
        Object o = this.getValue(index);
        return ObjectUtils.getInteger(o);
    }

    public final int getInt(ColumnExpr column) {
        return this.getInt(this.getFieldIndex(column));
    }

    public long getLong(int index) {
        Object o = this.getValue(index);
        return ObjectUtils.getLong(o);
    }

    public final long getLong(ColumnExpr column) {
        return this.getLong(this.getFieldIndex(column));
    }

    public double getDouble(int index) {
        Object v = this.getValue(index);
        return ObjectUtils.getDouble(v);
    }

    public final double getDouble(ColumnExpr column) {
        return this.getDouble(this.getFieldIndex(column));
    }

    public BigDecimal getDecimal(int index) {
        Object v = this.getValue(index);
        return ObjectUtils.getDecimal(v);
    }

    public final BigDecimal getDecimal(ColumnExpr column) {
        return this.getDecimal(this.getFieldIndex(column));
    }

    public boolean getBoolean(int index) {
        Object o = this.getValue(index);
        return ObjectUtils.getBoolean(o);
    }

    public final boolean getBoolean(ColumnExpr column) {
        return this.getBoolean(this.getFieldIndex(column));
    }

    public String getString(int index) {
        Object o = this.getValue(index);
        return StringUtils.toString(o);
    }

    public final String getString(ColumnExpr column) {
        return this.getString(this.getFieldIndex(column));
    }

    public Date getDateTime(int index) {
        Object o = this.getValue(index);
        return ObjectUtils.getDate(o);
    }

    public final Date getDateTime(ColumnExpr column) {
        return this.getDateTime(this.getFieldIndex(column));
    }

    @Override
    public boolean isNull(int index) {
        return this.getValue(index) == null;
    }

    @Override
    public final boolean isNull(ColumnExpr column) {
        return this.isNull(this.getFieldIndex(column));
    }

    protected void getBeanProperty(Object bean, String property, Object value) {
        try {
            if (value != null) {
                BeanUtils.setProperty((Object)bean, (String)property, (Object)value);
            } else {
                PropertyUtils.setProperty((Object)bean, (String)property, null);
            }
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            throw new BeanPropertySetException(bean, property, (Throwable)e);
        }
    }

    @Override
    public int getBeanProperties(Object bean, Collection<ColumnExpr> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            ColumnExpr column = this.getColumnExpr(i);
            if (ignoreList != null && ignoreList.contains(column)) continue;
            String property = column.getBeanPropertyName();
            this.getBeanProperty(bean, property, this.getValue(i));
            ++count;
        }
        return count;
    }

    @Override
    public final int getBeanProperties(Object bean) {
        return this.getBeanProperties(bean, null);
    }
}

