/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBXmlDictionary;
import org.apache.empire.db.exceptions.InternalSQLException;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.exceptions.BeanInstantiationException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBReader
extends DBRecordData {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(DBReader.class);
    private static ThreadLocal<Map<DBReader, Exception>> threadLocalOpenResultSets = new ThreadLocal();
    private DBDatabase db = null;
    private DBColumnExpr[] colList = null;
    protected ResultSet rset = null;
    private DBReaderIterator iterator = null;

    @Override
    public DBDatabase getDatabase() {
        return this.db;
    }

    public boolean getScrollable() {
        try {
            return this.rset != null && this.rset.getType() != 1003;
        }
        catch (SQLException e) {
            log.error("Cannot determine Resultset type", (Throwable)e);
            return false;
        }
    }

    @Override
    public int getFieldIndex(ColumnExpr column) {
        if (this.colList != null) {
            int i;
            for (i = 0; i < this.colList.length; ++i) {
                if (!this.colList[i].equals(column)) continue;
                return i;
            }
            if (column instanceof DBColumn) {
                for (i = 0; i < this.colList.length; ++i) {
                    DBColumn updColumn = this.colList[i].getUpdateColumn();
                    if (updColumn == null || !updColumn.equals(column)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    @Override
    public DBColumnExpr getColumnExpr(int iColumn) {
        if (this.colList == null || iColumn < 0 || iColumn >= this.colList.length) {
            return null;
        }
        return this.colList[iColumn];
    }

    @Override
    public int getFieldIndex(String column) {
        if (this.colList != null) {
            for (int i = 0; i < this.colList.length; ++i) {
                if (!this.colList[i].getName().equalsIgnoreCase(column)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean isNull(int index) {
        if (index < 0 || index >= this.colList.length) {
            log.error("Index out of range: " + index);
            return true;
        }
        try {
            this.rset.getObject(index + 1);
            return this.rset.wasNull();
        }
        catch (Exception e) {
            log.error("isNullValue exception", (Throwable)e);
            return super.isNull(index);
        }
    }

    @Override
    public Object getValue(int index) {
        if (index < 0 || index >= this.colList.length) {
            throw new InvalidArgumentException("index", index);
        }
        try {
            DataType dataType = this.colList[index].getDataType();
            return this.db.driver.getResultValue(this.rset, index + 1, dataType);
        }
        catch (SQLException e) {
            throw new InternalSQLException(this, e);
        }
    }

    public boolean isOpen() {
        return this.rset != null;
    }

    public void open(DBCommandExpr cmd, boolean scrollable, Connection conn) {
        if (this.isOpen()) {
            this.close();
        }
        String sqlCmd = cmd.getSelect();
        this.db = cmd.getDatabase();
        this.rset = this.db.executeQuery(sqlCmd, cmd.getParamValues(), scrollable, conn);
        if (this.rset == null) {
            throw new QueryNoResultException(sqlCmd);
        }
        this.colList = cmd.getSelectExprList();
        this.addOpenResultSet();
    }

    public final void open(DBCommandExpr cmd, Connection conn) {
        this.open(cmd, false, conn);
    }

    public void getRecordData(DBCommandExpr cmd, Connection conn) {
        this.open(cmd, conn);
        if (!this.moveNext()) {
            throw new QueryNoResultException(cmd.getSelect());
        }
    }

    @Override
    public void close() {
        try {
            if (this.iterator != null) {
                this.iterator.dispose();
                this.iterator = null;
            }
            if (this.rset != null) {
                this.getDatabase().closeResultSet(this.rset);
                this.removeOpenResultSet();
            }
            this.colList = null;
            this.rset = null;
        }
        catch (Exception e) {
            log.warn(e.toString());
        }
    }

    public boolean skipRows(int count) {
        try {
            if (this.rset == null) {
                throw new ObjectNotValidException(this);
            }
            int type = this.rset.getType();
            if (type == 1003) {
                if (count < 0) {
                    throw new InvalidArgumentException("count", count);
                }
                while (count > 0) {
                    if (!this.moveNext()) {
                        return false;
                    }
                    --count;
                }
                return true;
            }
            if (count > 0) {
                if (!this.rset.next()) {
                    return false;
                }
                if (count > 1) {
                    return this.rset.relative(count - 1);
                }
            } else if (count < 0) {
                if (!this.rset.previous()) {
                    return false;
                }
                if (count < -1) {
                    return this.rset.relative(count + 1);
                }
            }
            return true;
        }
        catch (SQLException e) {
            throw new InternalSQLException(this, e);
        }
    }

    public boolean moveNext() {
        try {
            if (this.rset == null) {
                throw new ObjectNotValidException(this);
            }
            if (!this.rset.next()) {
                this.close();
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            throw new InternalSQLException(this, e);
        }
    }

    public Iterator<DBRecordData> iterator(int maxCount) {
        if (this.iterator == null && this.rset != null) {
            this.iterator = this.getScrollable() ? new DBReaderScrollableIterator(maxCount) : new DBReaderForwardIterator(maxCount);
        }
        return this.iterator;
    }

    public final Iterator<DBRecordData> iterator() {
        return this.iterator(-1);
    }

    public void initRecord(DBRowSet rowset, DBRecord rec) {
        if (rowset == null) {
            throw new InvalidArgumentException("rowset", rowset);
        }
        rowset.initRecord(rec, this);
    }

    public <C extends Collection<T>, T> C getBeanList(C c, Class<T> t, int maxCount) {
        if (this.rset == null) {
            throw new ObjectNotValidException(this);
        }
        try {
            Object[] args;
            Class[] paramTypes = new Class[this.getFieldCount()];
            for (int i = 0; i < this.colList.length; ++i) {
                paramTypes[i] = DBExpr.getValueClass(this.colList[i].getDataType());
            }
            Constructor ctor = DBReader.findMatchingAccessibleConstructor(t, paramTypes);
            Object[] objectArray = args = ctor != null ? new Object[this.getFieldCount()] : null;
            while (this.moveNext() && maxCount != 0) {
                T bean;
                if (ctor != null) {
                    for (int i = 0; i < this.getFieldCount(); ++i) {
                        args[i] = this.getValue(i);
                    }
                    bean = ctor.newInstance(args);
                    c.add(bean);
                } else {
                    bean = t.newInstance();
                    this.getBeanProperties(bean);
                    c.add(bean);
                }
                if (maxCount <= 0) continue;
                --maxCount;
            }
            return c;
        }
        catch (InvocationTargetException e) {
            throw new BeanInstantiationException(t, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BeanInstantiationException(t, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BeanInstantiationException(t, (Throwable)e);
        }
    }

    public final <T> ArrayList<T> getBeanList(Class<T> t, int maxItems) {
        return this.getBeanList(new ArrayList(), t, maxItems);
    }

    public final <T> ArrayList<T> getBeanList(Class<T> t) {
        return this.getBeanList(t, -1);
    }

    @Override
    public int addColumnDesc(Element parent) {
        if (this.colList == null) {
            throw new ObjectNotValidException(this);
        }
        for (int i = 0; i < this.colList.length; ++i) {
            this.colList[i].addXml(parent, 0L);
        }
        return this.colList.length;
    }

    @Override
    public int addRowValues(Element parent) {
        if (this.rset == null) {
            throw new ObjectNotValidException(this);
        }
        for (int i = 0; i < this.colList.length; ++i) {
            String name = this.colList[i].getName();
            String idColumnAttr = this.getXmlDictionary().getRowIdColumnAttribute();
            if (name.equalsIgnoreCase("id")) {
                parent.setAttribute(idColumnAttr, this.getString(i));
                continue;
            }
            String value = this.getString(i);
            Element elem = XMLUtil.addElement(parent, name, value);
            if (value != null) continue;
            elem.setAttribute("null", "yes");
        }
        return this.colList.length;
    }

    public int addRows(Element parent) {
        int count = 0;
        if (this.rset == null) {
            return 0;
        }
        String rowElementName = this.getXmlDictionary().getRowElementName();
        while (this.moveNext()) {
            this.addRowValues(XMLUtil.addElement(parent, rowElementName));
            ++count;
        }
        return count;
    }

    protected DBXmlDictionary getXmlDictionary() {
        return DBXmlDictionary.getInstance();
    }

    @Override
    public Document getXmlDocument() {
        if (this.rset == null) {
            return null;
        }
        String rowsetElementName = this.getXmlDictionary().getRowSetElementName();
        Element root = XMLUtil.createDocument(rowsetElementName);
        this.addColumnDesc(root);
        this.addRows(root);
        return root.getOwnerDocument();
    }

    @Override
    public int getFieldCount() {
        return this.colList != null ? this.colList.length : 0;
    }

    private synchronized void addOpenResultSet() {
        Exception stackException;
        Map<DBReader, Exception> openResultSets = threadLocalOpenResultSets.get();
        if (openResultSets == null) {
            openResultSets = new HashMap<DBReader, Exception>(2);
            threadLocalOpenResultSets.set(openResultSets);
        }
        if ((stackException = openResultSets.get(this)) != null) {
            log.error("DBRecordSet.addOpenResultSet called for an object which is already in the open list. This is the stack of the method opening the object which was not previously closed.", (Throwable)stackException);
        }
        openResultSets.put(this, new Exception());
    }

    private synchronized void removeOpenResultSet() {
        Map<DBReader, Exception> openResultSets = threadLocalOpenResultSets.get();
        if (!openResultSets.containsKey(this)) {
            log.error("DBRecordSet.removeOpenResultSet called for an object which is not in the open list. Here is the current stack.", (Throwable)new Exception());
        } else {
            openResultSets.remove(this);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.rset != null) {
            throw new NotSerializableException(DBReader.class.getName() + " (due to attached ResultSet)");
        }
    }

    private static Constructor findMatchingAccessibleConstructor(Class clazz, Class[] parameterTypes) {
        int paramSize = parameterTypes.length;
        Constructor<?>[] ctors = clazz.getConstructors();
        int size = ctors.length;
        for (int i = 0; i < size; ++i) {
            Constructor ctor;
            Class<?>[] ctorParams = ctors[i].getParameterTypes();
            int ctorParamSize = ctorParams.length;
            if (ctorParamSize != paramSize) continue;
            boolean match = true;
            for (int n = 0; n < ctorParamSize; ++n) {
                if (ObjectUtils.isAssignmentCompatible(ctorParams[n], parameterTypes[n])) continue;
                match = false;
                break;
            }
            if (!match || (ctor = ConstructorUtils.getAccessibleConstructor(ctors[i])) == null) continue;
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            return ctor;
        }
        return null;
    }

    public static synchronized void checkOpenResultSets() {
        Map<DBReader, Exception> openResultSets = threadLocalOpenResultSets.get();
        if (openResultSets != null && !openResultSets.isEmpty()) {
            Object[] keySet = openResultSets.keySet().toArray();
            for (int i = 0; i < keySet.length; ++i) {
                Exception stackException = openResultSets.get(keySet[i]);
                log.error("A DBReader was not closed. Stack of opening code is ", (Throwable)stackException);
            }
            openResultSets.clear();
        }
    }

    public class DBReaderForwardIterator
    extends DBReaderIterator {
        private boolean getCurrent;
        private boolean hasCurrent;

        public DBReaderForwardIterator(int maxCount) {
            super(maxCount);
            this.getCurrent = true;
            this.hasCurrent = false;
        }

        public boolean hasNext() {
            if (this.curCount >= this.maxCount) {
                return false;
            }
            if (DBReader.this.rset == null) {
                throw new ObjectNotValidException(this);
            }
            if (this.getCurrent) {
                this.getCurrent = false;
                this.hasCurrent = DBReader.this.moveNext();
            }
            return this.hasCurrent;
        }

        public DBRecordData next() {
            if (!this.hasCurrent) {
                return null;
            }
            if (this.getCurrent && !DBReader.this.moveNext()) {
                this.hasCurrent = false;
                this.getCurrent = false;
                return null;
            }
            ++this.curCount;
            this.getCurrent = true;
            return DBReader.this;
        }
    }

    public class DBReaderScrollableIterator
    extends DBReaderIterator {
        public DBReaderScrollableIterator(int maxCount) {
            super(maxCount);
        }

        public boolean hasNext() {
            try {
                if (this.curCount >= this.maxCount) {
                    return false;
                }
                return DBReader.this.rset != null && !DBReader.this.rset.isLast() && !DBReader.this.rset.isAfterLast();
            }
            catch (SQLException e) {
                throw new InternalSQLException(DBReader.this.getDatabase(), e);
            }
        }

        public DBRecordData next() {
            if (this.curCount < this.maxCount && DBReader.this.moveNext()) {
                ++this.curCount;
                return DBReader.this;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class DBReaderIterator
    implements Iterator<DBRecordData> {
        protected int curCount = 0;
        protected int maxCount = 0;

        public DBReaderIterator(int maxCount) {
            if (maxCount < 0) {
                maxCount = Integer.MAX_VALUE;
            }
            this.maxCount = maxCount;
        }

        @Override
        public void remove() {
            log.error("DBReader.remove ist not implemented!");
        }

        public void dispose() {
            this.maxCount = -1;
            this.curCount = -1;
        }
    }
}

