/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBTable;
import org.apache.empire.exceptions.InvalidArgumentException;

public class DBIndex
extends DBObject {
    private static final long serialVersionUID = 1L;
    public static final int STANDARD = 0;
    public static final int UNIQUE = 1;
    public static final int PRIMARYKEY = 2;
    private String name;
    private int type;
    private DBColumn[] columns;
    private DBTable table;

    public DBIndex(String name, int type, DBColumn[] columns) {
        this.name = name;
        this.type = type;
        this.columns = columns;
    }

    public DBTable getTable() {
        return this.table;
    }

    void setTable(DBTable table) {
        if (table == null || !table.getIndexes().contains(this)) {
            throw new InvalidArgumentException("table", table);
        }
        this.table = table;
    }

    public DBDatabase getDatabase() {
        return this.table != null ? this.table.getDatabase() : null;
    }

    public String getName() {
        return this.name;
    }

    public DBColumn[] getColumns() {
        return this.columns;
    }

    public DBExpr[] getExpressions() {
        return this.columns;
    }

    public String getFullName() {
        String schema = this.getDatabase().getSchema();
        return schema != null ? schema + "." + this.name : this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean contains(DBColumn col) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!col.equals(this.columns[i])) continue;
            return true;
        }
        return false;
    }

    public int getColumnPos(DBColumn col) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!col.equals(this.columns[i])) continue;
            return i;
        }
        return -1;
    }
}

