/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.Iterator;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBIndex;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBView;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.MiscellaneousErrorException;
import org.apache.empire.exceptions.NotImplementedException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBDDLGenerator<T extends DBDatabaseDriver> {
    private static final Logger log = LoggerFactory.getLogger(DBDDLGenerator.class);
    protected T driver;
    protected String DATATYPE_INT_SMALL = "SMALLINT";
    protected String DATATYPE_INTEGER = "INT";
    protected String DATATYPE_INT_BIG = "BIGINT";
    protected String DATATYPE_CHAR = "CHAR";
    protected String DATATYPE_VARCHAR = "VARCHAR";
    protected String DATATYPE_DATE = "DATE";
    protected String DATATYPE_TIMESTAMP = "TIMESTAMP";
    protected String DATATYPE_BOOLEAN = "BIT";
    protected String DATATYPE_DECIMAL = "DECIMAL";
    protected String DATATYPE_FLOAT = "FLOAT";
    protected String DATATYPE_CLOB = "CLOB";
    protected String DATATYPE_BLOB = "BLOB";
    protected String DATATYPE_UNIQUEID = "CHAR(36)";
    protected boolean namePrimaryKeyConstraint = false;
    protected String alterColumnPhrase = " ALTER ";

    protected DBDDLGenerator(T driver) {
        this.driver = driver;
    }

    protected void addCreateTableStmt(DBTable table, StringBuilder sql, DBSQLScript script) {
        log.info("Adding create statmement for table {}.", (Object)table.getName());
        script.addStmt(sql);
    }

    protected void addCreateIndexStmt(DBIndex index, StringBuilder sql, DBSQLScript script) {
        log.info("Adding create statmement for index {}.", (Object)index.getName());
        script.addStmt(sql);
    }

    protected void addCreateRelationStmt(DBRelation rel, StringBuilder sql, DBSQLScript script) {
        log.info("Adding create statmement for relation {}.", (Object)rel.getName());
        script.addStmt(sql);
    }

    protected void addCreateViewStmt(DBView v, StringBuilder sql, DBSQLScript script) {
        log.info("Adding create statmement for view {}.", (Object)v.getName());
        script.addStmt(sql);
    }

    protected void addAlterTableStmt(DBColumn col, StringBuilder sql, DBSQLScript script) {
        log.info("Adding alter statmement for column {}.", (Object)col.getFullName());
        script.addStmt(sql);
    }

    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, StringBuilder sql) {
        switch (type) {
            case INTEGER: 
            case AUTOINC: {
                int bytes = Math.abs((int)size);
                if (bytes > 0 && bytes < 3) {
                    sql.append(this.DATATYPE_INT_SMALL);
                    break;
                }
                if (bytes > 4) {
                    sql.append(this.DATATYPE_INT_BIG);
                    break;
                }
                sql.append(this.DATATYPE_INTEGER);
                break;
            }
            case TEXT: 
            case CHAR: {
                sql.append(type == DataType.CHAR ? this.DATATYPE_CHAR : this.DATATYPE_VARCHAR);
                int len = Math.abs((int)size);
                if (len == 0) {
                    len = type == DataType.CHAR ? 1 : 100;
                }
                sql.append("(");
                sql.append(String.valueOf(len));
                sql.append(")");
                break;
            }
            case DATE: {
                sql.append(this.DATATYPE_DATE);
                break;
            }
            case DATETIME: {
                sql.append(this.DATATYPE_TIMESTAMP);
                break;
            }
            case BOOL: {
                sql.append(this.DATATYPE_BOOLEAN);
                break;
            }
            case FLOAT: {
                sql.append(this.DATATYPE_FLOAT);
                int prec = Math.abs((int)size);
                if (prec <= 0) break;
                sql.append("(");
                sql.append(String.valueOf(prec));
                sql.append(")");
                break;
            }
            case DECIMAL: {
                sql.append(this.DATATYPE_DECIMAL);
                int prec = (int)size;
                int scale = (int)((size - (double)prec) * 10.0 + 0.5);
                if (prec <= 0) break;
                sql.append("(");
                sql.append(String.valueOf(prec));
                sql.append(",");
                sql.append(String.valueOf(scale));
                sql.append(")");
                break;
            }
            case CLOB: {
                sql.append(this.DATATYPE_CLOB);
                break;
            }
            case BLOB: {
                sql.append(this.DATATYPE_BLOB);
                if (!(size > 0.0)) break;
                sql.append("(" + (long)size + ") ");
                break;
            }
            case UNIQUEID: {
                sql.append(this.DATATYPE_UNIQUEID);
                break;
            }
            default: {
                throw new MiscellaneousErrorException("Error: Unable to append column of type UNKNOWN");
            }
        }
        return true;
    }

    protected void appendColumnDesc(DBTableColumn c, boolean alter, StringBuilder sql) {
        c.addSQL(sql, 1L);
        sql.append(" ");
        if (!this.appendColumnDataType(c.getDataType(), c.getSize(), c, sql)) {
            return;
        }
        if (((DBDatabaseDriver)this.driver).isDDLColumnDefaults() && !c.isAutoGenerated() && c.getDefaultValue() != null) {
            sql.append(" DEFAULT ");
            sql.append(((DBDatabaseDriver)this.driver).getValueString(c.getDefaultValue(), c.getDataType()));
        }
        if (c.isRequired() || c.isAutoGenerated()) {
            sql.append(" NOT NULL");
        }
    }

    public void getDDLScript(DBCmdType type, DBObject dbo, DBSQLScript script) {
        if (dbo == null || dbo.getDatabase().getDriver() != this.driver) {
            throw new InvalidArgumentException("dbo", dbo);
        }
        if (dbo instanceof DBDatabase) {
            switch (type) {
                case CREATE: {
                    this.createDatabase((DBDatabase)dbo, script);
                    return;
                }
                case DROP: {
                    this.dropObject(((DBDatabase)dbo).getSchema(), "USER", script);
                    return;
                }
            }
            throw new NotImplementedException(this, "getDDLScript." + dbo.getClass().getName() + "." + (Object)((Object)type));
        }
        if (dbo instanceof DBTable) {
            switch (type) {
                case CREATE: {
                    this.createTable((DBTable)dbo, script);
                    return;
                }
                case DROP: {
                    this.dropObject(((DBTable)dbo).getName(), "TABLE", script);
                    return;
                }
            }
            throw new NotImplementedException(this, "getDDLScript." + dbo.getClass().getName() + "." + (Object)((Object)type));
        }
        if (dbo instanceof DBView) {
            switch (type) {
                case CREATE: {
                    this.createView((DBView)dbo, script);
                    return;
                }
                case DROP: {
                    this.dropObject(((DBView)dbo).getName(), "VIEW", script);
                    return;
                }
                case ALTER: {
                    this.dropObject(((DBView)dbo).getName(), "VIEW", script);
                    this.createView((DBView)dbo, script);
                    return;
                }
            }
            throw new NotImplementedException(this, "getDDLScript." + dbo.getClass().getName() + "." + (Object)((Object)type));
        }
        if (dbo instanceof DBRelation) {
            switch (type) {
                case CREATE: {
                    this.createRelation((DBRelation)dbo, script);
                    return;
                }
                case DROP: {
                    this.dropObject(((DBRelation)dbo).getName(), "CONSTRAINT", script);
                    return;
                }
            }
            throw new NotImplementedException(this, "getDDLScript." + dbo.getClass().getName() + "." + (Object)((Object)type));
        }
        if (dbo instanceof DBTableColumn) {
            this.alterTable((DBTableColumn)dbo, type, script);
            return;
        }
        throw new NotSupportedException(this, "getDDLScript() for " + dbo.getClass().getName());
    }

    protected void createDatabase(DBDatabase db, DBSQLScript script) {
        Iterator<DBTable> tables = db.getTables().iterator();
        while (tables.hasNext()) {
            this.createTable(tables.next(), script);
        }
        Iterator<DBRelation> relations = db.getRelations().iterator();
        while (relations.hasNext()) {
            this.createRelation(relations.next(), script);
        }
        for (DBView v : db.getViews()) {
            try {
                this.createView(v, script);
            }
            catch (NotSupportedException e) {
                log.warn("Error creating the view {0}. This view will be ignored.", (Object)v.getName());
            }
        }
    }

    protected void dropDatabase(DBDatabase db, DBSQLScript script) {
        this.dropObject(db.getSchema(), "DATABASE", script);
    }

    protected void createTable(DBTable t, DBSQLScript script) {
        StringBuilder sql = new StringBuilder();
        sql.append("-- creating table ");
        sql.append(t.getName());
        sql.append(" --\r\n");
        sql.append("CREATE TABLE ");
        t.addSQL(sql, 2L);
        sql.append(" (");
        boolean addSeparator = false;
        for (DBTableColumn dBTableColumn : t.getColumns()) {
            if (dBTableColumn.getDataType() == DataType.UNKNOWN) continue;
            sql.append(addSeparator ? ",\r\n   " : "\r\n   ");
            this.appendColumnDesc(dBTableColumn, false, sql);
            addSeparator = true;
        }
        DBIndex dBIndex = t.getPrimaryKey();
        if (dBIndex != null) {
            sql.append(",\r\n");
            if (this.namePrimaryKeyConstraint) {
                sql.append(" CONSTRAINT ");
                this.appendElementName(sql, dBIndex.getName());
            }
            sql.append(" PRIMARY KEY (");
            addSeparator = false;
            DBColumn[] keyColumns = dBIndex.getColumns();
            for (int i = 0; i < keyColumns.length; ++i) {
                sql.append(addSeparator ? ", " : "");
                keyColumns[i].addSQL(sql, 1L);
                addSeparator = true;
            }
            sql.append(")");
        }
        sql.append(")");
        this.addCreateTableStmt(t, sql, script);
        this.createTableIndexes(t, dBIndex, script);
    }

    protected void createTableIndexes(DBTable t, DBIndex pk, DBSQLScript script) {
        StringBuilder sql = new StringBuilder();
        for (DBIndex idx : t.getIndexes()) {
            if (idx == pk || idx.getType() == 2) continue;
            sql.setLength(0);
            sql.append(idx.getType() == 1 ? "CREATE UNIQUE INDEX " : "CREATE INDEX ");
            this.appendElementName(sql, idx.getName());
            sql.append(" ON ");
            t.addSQL(sql, 2L);
            sql.append(" (");
            boolean addSeparator = false;
            DBExpr[] idxColumns = idx.getExpressions();
            for (int i = 0; i < idxColumns.length; ++i) {
                sql.append(addSeparator ? ", " : "");
                idxColumns[i].addSQL(sql, 1L);
                sql.append("");
                addSeparator = true;
            }
            sql.append(")");
            this.addCreateIndexStmt(idx, sql, script);
        }
    }

    protected void createRelation(DBRelation r, DBSQLScript script) {
        int i;
        DBTable sourceTable = (DBTable)r.getReferences()[0].getSourceColumn().getRowSet();
        DBTable targetTable = (DBTable)r.getReferences()[0].getTargetColumn().getRowSet();
        StringBuilder sql = new StringBuilder();
        sql.append("-- creating foreign key constraint ");
        sql.append(r.getName());
        sql.append(" --\r\n");
        sql.append("ALTER TABLE ");
        sourceTable.addSQL(sql, 2L);
        sql.append(" ADD CONSTRAINT ");
        this.appendElementName(sql, r.getName());
        sql.append(" FOREIGN KEY (");
        boolean addSeparator = false;
        DBRelation.DBReference[] refs = r.getReferences();
        for (i = 0; i < refs.length; ++i) {
            sql.append(addSeparator ? ", " : "");
            refs[i].getSourceColumn().addSQL(sql, 1L);
            addSeparator = true;
        }
        sql.append(") REFERENCES ");
        targetTable.addSQL(sql, 2L);
        sql.append(" (");
        addSeparator = false;
        for (i = 0; i < refs.length; ++i) {
            sql.append(addSeparator ? ", " : "");
            refs[i].getTargetColumn().addSQL(sql, 1L);
            addSeparator = true;
        }
        sql.append(")");
        if (r.getOnDeleteAction() == DBRelation.DBCascadeAction.CASCADE) {
            sql.append(" ON DELETE CASCADE");
        }
        this.addCreateRelationStmt(r, sql, script);
    }

    protected void alterTable(DBTableColumn col, DBCmdType type, DBSQLScript script) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        col.getRowSet().addSQL(sql, 2L);
        switch (type) {
            case CREATE: {
                sql.append(" ADD ");
                this.appendColumnDesc(col, false, sql);
                break;
            }
            case ALTER: {
                sql.append(this.alterColumnPhrase);
                this.appendColumnDesc(col, true, sql);
                break;
            }
            case DROP: {
                sql.append(" DROP COLUMN ");
                sql.append(col.getName());
            }
        }
        this.addAlterTableStmt(col, sql, script);
    }

    protected void createView(DBView v, DBSQLScript script) {
        DBCommandExpr cmd = v.createCommand();
        if (cmd == null) {
            log.error("No command has been supplied for view " + v.getName());
            throw new NotSupportedException(this, v.getName() + ".createCommand");
        }
        cmd.clearOrderBy();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE VIEW ");
        v.addSQL(sql, 2L);
        sql.append(" (");
        boolean addSeparator = false;
        for (DBColumn c : v.getColumns()) {
            if (addSeparator) {
                sql.append(", ");
            }
            c.addSQL(sql, 1L);
            addSeparator = true;
        }
        sql.append(")\r\nAS\r\n");
        cmd.addSQL(sql, 7L);
        this.addCreateViewStmt(v, sql, script);
    }

    protected void dropObject(String name, String objType, DBSQLScript script) {
        if (name == null || name.length() == 0) {
            throw new InvalidArgumentException("name", name);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("DROP ");
        sql.append(objType);
        sql.append(" ");
        this.appendElementName(sql, name);
        script.addStmt(sql);
    }

    protected boolean detectQuoteName(String name) {
        return ((DBDatabaseDriver)this.driver).detectQuoteName(name);
    }

    protected void appendElementName(StringBuilder sql, String name) {
        ((DBDatabaseDriver)this.driver).appendElementName(sql, name);
    }
}

