/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.Set;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.DatabaseNotOpenException;
import org.apache.empire.db.expr.set.DBSetExpr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBColumn
extends DBColumnExpr
implements Column {
    private static final long serialVersionUID = 1L;
    public static final String DBCOLATTR_MANDATORY = "mandatory";
    public static final String DBCOLATTR_READONLY = "readonly";
    public static final String DBCOLATTR_MINVALUE = "minValue";
    public static final String DBCOLATTR_MAXVALUE = "maxValue";
    public static final String DBCOLATTR_SINGLEBYTECHARS = "singleByteChars";
    protected final DBRowSet rowset;
    protected final String name;
    protected String comment;
    private Boolean quoteName = null;

    protected DBColumn(DBRowSet rowset, String name) {
        this.rowset = rowset;
        this.name = name;
        this.comment = null;
    }

    @Override
    public abstract double getSize();

    @Override
    public abstract boolean isRequired();

    @Override
    public abstract boolean isAutoGenerated();

    @Override
    public abstract boolean isReadOnly();

    @Override
    public abstract void validate(Object var1);

    @Deprecated
    public final void checkValue(Object value) {
        this.validate(value);
    }

    public boolean isTextColumn() {
        DataType type = this.getDataType();
        return type == DataType.TEXT || type == DataType.CHAR || type == DataType.CLOB;
    }

    public boolean isNumericColumn() {
        DataType type = this.getDataType();
        return type == DataType.INTEGER || type == DataType.DECIMAL || type == DataType.FLOAT || type == DataType.AUTOINC;
    }

    public boolean isDateColumn() {
        DataType type = this.getDataType();
        return type == DataType.DATE || type == DataType.DATETIME;
    }

    public boolean isLOBColumn() {
        DataType type = this.getDataType();
        return type == DataType.CLOB || type == DataType.BLOB;
    }

    @Override
    public abstract Element addXml(Element var1, long var2);

    @Override
    public DBDatabase getDatabase() {
        return this.rowset != null ? this.rowset.getDatabase() : null;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
        list.add(this);
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        DBDatabaseDriver driver;
        if ((context & 2L) != 0L) {
            buf.append(this.rowset.getAlias());
            buf.append(".");
        }
        if ((driver = this.getDatabase().getDriver()) == null) {
            throw new DatabaseNotOpenException(this.getDatabase());
        }
        if (this.quoteName == null) {
            this.quoteName = driver.detectQuoteName(this.name);
        }
        driver.appendElementName(buf, this.name, this.quoteName);
    }

    @Override
    public DBColumn getUpdateColumn() {
        return this;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public DBRowSet getRowSet() {
        return this.rowset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.rowset == null) {
            return this.name;
        }
        return this.rowset.getFullName() + "." + this.name;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    public DBSetExpr to(Object value) {
        return new DBSetExpr(this, value);
    }

    public String toString() {
        if (this.rowset == null) {
            return this.name;
        }
        return this.rowset.getName() + "." + this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

