/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.bean;

import java.util.ArrayList;
import java.util.List;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataMode;
import org.apache.empire.data.DataType;
import org.apache.empire.data.bean.BeanDomain;
import org.apache.empire.data.bean.BeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanClass {
    private final String name;
    private final List<BeanProperty> properties = new ArrayList<BeanProperty>();
    private Column[] keyColumns;
    protected BeanDomain domain;

    protected BeanClass(String name) {
        this.name = name;
    }

    protected BeanClass(String name, BeanDomain dom) {
        this(name);
        dom.addClass(this);
    }

    protected void addProp(BeanProperty prop) {
        this.properties.add(prop);
        prop.beanClass = this;
    }

    protected final BeanProperty addProp(String propname, DataType dataType, double size, DataMode dataMode, String controlType) {
        BeanProperty prop = new BeanProperty(propname, dataType, size, dataMode, controlType);
        this.addProp(prop);
        return prop;
    }

    protected final BeanProperty addProp(String propname, DataType dataType, double size, DataMode dataMode) {
        return this.addProp(propname, dataType, size, dataMode, "text");
    }

    protected final BeanProperty addProp(String propname, DataType dataType, double size, boolean required, String controlType, boolean readOnly) {
        BeanProperty prop = new BeanProperty(propname, dataType, size, required, controlType, readOnly);
        this.addProp(prop);
        return prop;
    }

    protected final BeanProperty addProp(String propname, DataType dataType, double size, boolean required, String controlType) {
        return this.addProp(propname, dataType, size, required, controlType, false);
    }

    protected final BeanProperty addProp(String propname, DataType dataType, double size, boolean required) {
        return this.addProp(propname, dataType, size, required, "text", false);
    }

    protected void setKeyColumns(Column[] keyColumns) {
        this.keyColumns = keyColumns;
    }

    protected final void setKeyColumn(Column keyColumn) {
        this.setKeyColumns(new Column[]{keyColumn});
    }

    public String getName() {
        return this.name;
    }

    public List<BeanProperty> getProperties() {
        return this.properties;
    }

    public BeanDomain getDomain() {
        return this.domain;
    }

    public Column[] getKeyColumns() {
        return this.keyColumns;
    }
}

