/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

public class StringUtils {
    private StringUtils() {
    }

    public static String toString(Object value, String defValue) {
        return value != null ? value.toString() : defValue;
    }

    public static String toString(Object value) {
        return StringUtils.toString(value, null);
    }

    public static String toString(Object[] array, String defValue) {
        String s = StringUtils.arrayToString(array, "/");
        return s != null ? s : defValue;
    }

    public static String toString(Object[] array) {
        return StringUtils.toString(array, null);
    }

    public static String valueOf(Object value) {
        return StringUtils.toString(value, "null");
    }

    public static String valueOf(Object[] array) {
        return StringUtils.toString(array, "null");
    }

    public static String coalesce(String preferred, String alternative) {
        return StringUtils.isValid(preferred) ? preferred : alternative;
    }

    public static String nullIfEmpty(Object value) {
        if (value == null) {
            return null;
        }
        String strval = value.toString();
        return strval.length() == 0 ? null : strval;
    }

    public static String arrayToString(Object[] array, String separator) {
        if (array == null || array.length < 1) {
            return null;
        }
        if (array.length > 1) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                if (i > 0 && separator != null) {
                    buf.append(separator);
                }
                buf.append(array[i]);
            }
            return buf.toString();
        }
        return String.valueOf(array[0]);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    @Deprecated
    public static boolean isValid(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean isNotEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean compareEqual(String s1, String s2, boolean ignoreCase) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return ignoreCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
    }

    public static String validate(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    public static String replace(String source, String find, String replace) {
        if (source == null || find == null || find.length() == 0) {
            return source;
        }
        int index = source.indexOf(find);
        if (index < 0) {
            return source;
        }
        if (replace == null) {
            replace = "";
        }
        int len = find.length();
        return source.substring(0, index) + replace + StringUtils.replace(source.substring(index + len), find, replace);
    }

    public static String replaceAll(String source, String find, String replace) {
        StringBuilder buffer;
        boolean greaterLength;
        if (source == null) {
            return null;
        }
        if (find == null || "".equals(find)) {
            return source;
        }
        if (replace == null) {
            replace = "";
        }
        int fromLength = find.length();
        int start = source.indexOf(find);
        if (start == -1) {
            return source;
        }
        boolean bl = greaterLength = replace.length() >= fromLength;
        if (greaterLength) {
            if (find.equals(replace)) {
                return source;
            }
            buffer = new StringBuilder(source.length());
        } else {
            buffer = new StringBuilder();
        }
        char[] origChars = source.toCharArray();
        int copyFrom = 0;
        while (start != -1) {
            buffer.append(origChars, copyFrom, start - copyFrom);
            buffer.append(replace);
            copyFrom = start + fromLength;
            start = source.indexOf(find, copyFrom);
        }
        buffer.append(origChars, copyFrom, origChars.length - copyFrom);
        return buffer.toString();
    }
}

