/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
extends AbstractSet<OptionEntry>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_STRING = "";
    private ArrayList<OptionEntry> list = new ArrayList();

    public Options() {
    }

    public Options(Options other) {
        this.addAll(other);
    }

    public Options clone() {
        return new Options(this);
    }

    public Options(OptionEntry[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            this.add(entries[i]);
        }
    }

    protected int getIndex(Object value) {
        if (value instanceof Map.Entry) {
            value = ((Map.Entry)value).getKey();
        }
        if (value instanceof OptionEntry) {
            value = ((OptionEntry)value).getValue();
        }
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            Object v = this.list.get(i).getValue();
            if (!ObjectUtils.compareEqual(value, v)) continue;
            return i;
        }
        return -1;
    }

    protected OptionEntry createOptionEntry(Object value, String text) {
        return new OptionEntry(value, text);
    }

    public OptionEntry getEntry(Object value) {
        int i = this.getIndex(value);
        return i >= 0 ? this.list.get(i) : null;
    }

    public String get(Object value) {
        int i = this.getIndex(value);
        return i >= 0 ? this.list.get(i).getText() : EMPTY_STRING;
    }

    public Object getValueAt(int i) {
        return i >= 0 && i < this.list.size() ? this.list.get(i).getValue() : null;
    }

    public String getTextAt(int i) {
        return i >= 0 && i < this.list.size() ? this.list.get(i).getText() : EMPTY_STRING;
    }

    public Set<Object> getValues() {
        HashSet<Object> set = new HashSet<Object>(this.list.size());
        for (OptionEntry e : this.list) {
            set.add(e.getValue());
        }
        return set;
    }

    public void set(Object value, String text, InsertPos pos) {
        if (text == null) {
            return;
        }
        int i = this.getIndex(value);
        if (i >= 0) {
            this.list.get(i).setText(text);
        } else {
            int index = pos == InsertPos.Top ? 0 : (pos == InsertPos.Sort ? this.findInsertPos(text) : this.list.size());
            this.list.add(index, this.createOptionEntry(value, text));
        }
    }

    public void set(Object value, String text) {
        this.set(value, text, InsertPos.Bottom);
    }

    public void add(Object value, String text, boolean noCheck) {
        if (noCheck) {
            this.list.add(this.createOptionEntry(value, text));
        } else {
            this.set(value, text);
        }
    }

    @Override
    public boolean add(OptionEntry option) {
        if (option.getText() == null) {
            return false;
        }
        int i = this.getIndex(option.getValue());
        if (i >= 0) {
            this.list.set(i, option);
        } else {
            this.list.add(option);
        }
        return true;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.getIndex(object) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    @Override
    public Iterator<OptionEntry> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean remove(Object object) {
        int i = this.getIndex(object);
        if (i < 0) {
            return false;
        }
        this.list.remove(i);
        return true;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        boolean first = true;
        for (OptionEntry e : this.list) {
            b.append(first ? "\"" : ",\r\n \"");
            b.append(StringUtils.toString(e.getValue()));
            b.append("\":\"");
            b.append(e.getText());
            b.append("\"");
            first = false;
        }
        b.append("}");
        return b.toString();
    }

    public void addXml(Element element, long flags) {
        for (OptionEntry e : this.list) {
            String value = String.valueOf(e.getValue());
            Element opt = XMLUtil.addElement(element, "option", e.getText());
            opt.setAttribute("value", value);
        }
    }

    private int findInsertPos(String text) {
        OptionEntry e;
        int i;
        for (i = 0; i < this.list.size() && text.compareToIgnoreCase((e = this.list.get(i)).getText()) > 0; ++i) {
        }
        return i;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InsertPos {
        Top,
        Bottom,
        Sort;

    }
}

