/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.empire.commons.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectUtils {
    public static final NoValue NO_VALUE = new NoValue();
    private static final Logger log = LoggerFactory.getLogger(ObjectUtils.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd hh:mm:ss";

    private ObjectUtils() {
    }

    public static boolean isEmpty(Object o) {
        if (o == null || o == NO_VALUE) {
            return true;
        }
        return o instanceof String && ((String)o).length() == 0;
    }

    public static boolean compareEqual(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        if (o1.getClass().equals(o2.getClass())) {
            return o1.equals(o2);
        }
        if (o1.equals(o2) || o2.equals(o1)) {
            return true;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            double d2;
            double d1 = ((Number)o1).doubleValue();
            return d1 == (d2 = ((Number)o2).doubleValue());
        }
        return o1.toString().equals(o2.toString());
    }

    public static <T> T coalesce(T preferred, T alternative) {
        return preferred != null ? preferred : alternative;
    }

    public static int getInteger(Object v, int defValue) {
        if (v == null) {
            return defValue;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        try {
            String str = v.toString();
            if (str.length() == 0) {
                return defValue;
            }
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            log.warn(String.format("Cannot convert value [%s] to int!", v));
            return defValue;
        }
    }

    public static int getInteger(Object v) {
        return ObjectUtils.getInteger(v, 0);
    }

    public static long getLong(Object v, long defValue) {
        if (v == null) {
            return defValue;
        }
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        try {
            String str = v.toString();
            if (str.length() == 0) {
                return defValue;
            }
            return Long.parseLong(str);
        }
        catch (Exception e) {
            log.warn(String.format("Cannot convert value [%s] to long!", v));
            return defValue;
        }
    }

    public static long getLong(Object v) {
        return ObjectUtils.getLong(v, 0L);
    }

    public static double getDouble(Object v, double defValue) {
        if (v == null) {
            return defValue;
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        try {
            String val = v.toString();
            return Double.parseDouble(val);
        }
        catch (Exception e) {
            log.warn(String.format("Cannot convert value [%s] to double!", v));
            return defValue;
        }
    }

    public static double getDouble(Object v) {
        return ObjectUtils.getDouble(v, 0.0);
    }

    public static BigDecimal getDecimal(Object v, BigDecimal defValue) {
        if (v == null) {
            return defValue;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        if (v instanceof Number) {
            if (v instanceof BigInteger) {
                return new BigDecimal((BigInteger)v);
            }
            if (v instanceof Integer) {
                return BigDecimal.valueOf(((Number)v).intValue());
            }
            if (v instanceof Long) {
                return BigDecimal.valueOf(((Number)v).longValue());
            }
            return BigDecimal.valueOf(((Number)v).doubleValue());
        }
        try {
            return new BigDecimal(v.toString());
        }
        catch (Exception e) {
            log.warn(String.format("Cannot convert value [%s] to BigDecimal!", v));
            return defValue;
        }
    }

    public static BigDecimal getDecimal(Object v) {
        return ObjectUtils.getDecimal(v, BigDecimal.ZERO);
    }

    public static boolean getBoolean(Object v) {
        if (v == null) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue() != 0;
        }
        String val = v.toString();
        return val.equalsIgnoreCase("Y") || val.equalsIgnoreCase("true");
    }

    public static Date getDate(Object v, Locale locale) {
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        if (v instanceof Number) {
            long l = ((Number)v).longValue();
            if (l == 0L) {
                return DateUtils.getDateNow();
            }
            return new Date(l);
        }
        return DateUtils.parseDate(v.toString(), locale);
    }

    public static Date getDate(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        try {
            String str = v.toString();
            if (str.length() > 10) {
                return new SimpleDateFormat(DATETIME_FORMAT).parse(str);
            }
            return new SimpleDateFormat(DATE_FORMAT).parse(str);
        }
        catch (Exception e) {
            log.error("Cannot convert value to date!", (Throwable)e);
            return null;
        }
    }

    public static String formatDate(Date date, boolean withTime) {
        if (withTime) {
            return new SimpleDateFormat(DATETIME_FORMAT).format(date);
        }
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    public static <T> T convert(Class<T> c, Object v) throws ClassCastException {
        if (v == null || c.isInstance(v)) {
            return (T)v;
        }
        if (c.isAssignableFrom(Boolean.class)) {
            return c.cast(ObjectUtils.getBoolean(v));
        }
        if (c.isAssignableFrom(Integer.class)) {
            return c.cast(ObjectUtils.getInteger(v));
        }
        if (c.isAssignableFrom(Long.class)) {
            return c.cast(ObjectUtils.getLong(v));
        }
        if (c.isAssignableFrom(Double.class)) {
            return c.cast(ObjectUtils.getDouble(v));
        }
        if (c.isAssignableFrom(String.class)) {
            return c.cast(v.toString());
        }
        return c.cast(v);
    }

    public static boolean isAssignmentCompatible(Class<?> target, Class<?> source) {
        Class<Number> numberClass;
        if (target.isAssignableFrom(source)) {
            return true;
        }
        if (source.isPrimitive()) {
            if ((source = MethodUtils.getPrimitiveWrapper(source)) == null) {
                return false;
            }
            if (target.isAssignableFrom(source)) {
                return true;
            }
        }
        if (target.isPrimitive()) {
            if ((target = MethodUtils.getPrimitiveWrapper(target)) == null) {
                return false;
            }
            if (target.isAssignableFrom(source)) {
                return true;
            }
        }
        return (numberClass = Number.class).isAssignableFrom(target) && numberClass.isAssignableFrom(source);
    }

    public static <T> List<T> convert(Class<T> t, Collection<? extends T> source) {
        ArrayList<? extends T> target = new ArrayList<T>();
        target.addAll(source);
        return target;
    }

    public static String[] toStringArray(Object[] objArray, String defValue) {
        if (objArray == null) {
            return null;
        }
        String[] strArray = new String[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            strArray[i] = objArray[i] != null ? objArray[i].toString() : defValue;
        }
        return strArray;
    }

    public static <T> boolean contains(T[] array, T item) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == item) {
                return true;
            }
            if (array[i] == null || !array[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    public static class NoValue {
        private NoValue() {
        }

        public String toString() {
            return "[NO-VALUE]";
        }
    }
}

