/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.io.CountingOutputStream;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlQuery;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

@Path(value="/druid/v2/sql/")
public class SqlResource {
    private static final Logger log = new Logger(SqlResource.class);
    private final ObjectMapper jsonMapper;
    private final SqlLifecycleFactory sqlLifecycleFactory;

    @Inject
    public SqlResource(@Json ObjectMapper jsonMapper, SqlLifecycleFactory sqlLifecycleFactory) {
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
        this.sqlLifecycleFactory = (SqlLifecycleFactory)Preconditions.checkNotNull((Object)sqlLifecycleFactory, (Object)"sqlLifecycleFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response doPost(SqlQuery sqlQuery, @Context HttpServletRequest req) throws IOException {
        SqlLifecycle lifecycle = this.sqlLifecycleFactory.factorize();
        String sqlQueryId = lifecycle.initialize(sqlQuery.getQuery(), sqlQuery.getContext());
        String remoteAddr = req.getRemoteAddr();
        String currThreadName = Thread.currentThread().getName();
        try {
            SqlTypeName sqlTypeName;
            Thread.currentThread().setName(StringUtils.format((String)"sql[%s]", (Object[])new Object[]{sqlQueryId}));
            PlannerContext plannerContext = lifecycle.planAndAuthorize(req);
            DateTimeZone timeZone = plannerContext.getTimeZone();
            List fieldList = lifecycle.rowType().getFieldList();
            boolean[] timeColumns = new boolean[fieldList.size()];
            boolean[] dateColumns = new boolean[fieldList.size()];
            String[] columnNames = new String[fieldList.size()];
            for (int i = 0; i < fieldList.size(); ++i) {
                sqlTypeName = ((RelDataTypeField)fieldList.get(i)).getType().getSqlTypeName();
                timeColumns[i] = sqlTypeName == SqlTypeName.TIMESTAMP;
                dateColumns[i] = sqlTypeName == SqlTypeName.DATE;
                columnNames[i] = ((RelDataTypeField)fieldList.get(i)).getName();
            }
            Yielder yielder0 = Yielders.each(lifecycle.execute());
            try {
                sqlTypeName = Response.ok(outputStream -> {
                    Exception e = null;
                    CountingOutputStream os = new CountingOutputStream(outputStream);
                    Yielder yielder = yielder0;
                    try (ResultFormat.Writer writer = sqlQuery.getResultFormat().createFormatter((OutputStream)os, this.jsonMapper);){
                        writer.writeResponseStart();
                        if (sqlQuery.includeHeader()) {
                            writer.writeHeader(Arrays.asList(columnNames));
                        }
                        while (!yielder.isDone()) {
                            Object[] row = (Object[])yielder.get();
                            writer.writeRowStart();
                            for (int i = 0; i < fieldList.size(); ++i) {
                                Object value = timeColumns[i] ? ISODateTimeFormat.dateTime().print((ReadableInstant)Calcites.calciteTimestampToJoda((Long)row[i], timeZone)) : (dateColumns[i] ? ISODateTimeFormat.dateTime().print((ReadableInstant)Calcites.calciteDateToJoda((Integer)row[i], timeZone)) : row[i]);
                                writer.writeRowField(((RelDataTypeField)fieldList.get(i)).getName(), value);
                            }
                            writer.writeRowEnd();
                            yielder = yielder.next(null);
                        }
                        writer.writeResponseEnd();
                    }
                    catch (Exception ex) {
                        e = ex;
                        log.error((Throwable)ex, "Unable to send sql response [%s]", new Object[]{sqlQueryId});
                        throw new RuntimeException(ex);
                    }
                    finally {
                        yielder.close();
                        lifecycle.emitLogsAndMetrics(e, remoteAddr, os.getCount());
                    }
                }).header("X-Druid-SQL-Query-Id", (Object)sqlQueryId).build();
                return sqlTypeName;
            }
            catch (Throwable e) {
                try {
                    yielder0.close();
                    throw new RuntimeException(e);
                }
                catch (ForbiddenException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    log.warn((Throwable)e3, "Failed to handle query: %s", new Object[]{sqlQuery});
                    lifecycle.emitLogsAndMetrics(e3, remoteAddr, -1L);
                    Exception exceptionToReport = e3 instanceof RelOptPlanner.CannotPlanException ? new ISE("Cannot build plan for query: %s", new Object[]{sqlQuery.getQuery()}) : e3;
                    Response response = Response.serverError().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.jsonMapper.writeValueAsBytes((Object)QueryInterruptedException.wrapIfNeeded((Throwable)exceptionToReport))).build();
                    return response;
                }
            }
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }
}

