/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.planner.Calcites;

public class RowSignature {
    private final Map<String, ValueType> columnTypes;
    private final List<String> columnNames;

    private RowSignature(List<Pair<String, ValueType>> columnTypeList) {
        HashMap<Object, Object> columnTypes0 = new HashMap<Object, Object>();
        ImmutableList.Builder columnNamesBuilder = ImmutableList.builder();
        boolean i = false;
        for (Pair<String, ValueType> pair : columnTypeList) {
            ValueType existingType = (ValueType)columnTypes0.get(pair.lhs);
            if (existingType != null && existingType != pair.rhs) {
                throw new IAE("Column[%s] has conflicting types [%s] and [%s]", new Object[]{pair.lhs, existingType, pair.rhs});
            }
            columnTypes0.put(pair.lhs, pair.rhs);
            columnNamesBuilder.add(pair.lhs);
        }
        this.columnTypes = ImmutableMap.copyOf(columnTypes0);
        this.columnNames = columnNamesBuilder.build();
    }

    public static RowSignature from(List<String> rowOrder, RelDataType rowType) {
        if (rowOrder.size() != rowType.getFieldCount()) {
            throw new IAE("Field count %d != %d", new Object[]{rowOrder.size(), rowType.getFieldCount()});
        }
        Builder rowSignatureBuilder = RowSignature.builder();
        for (int i = 0; i < rowOrder.size(); ++i) {
            RelDataTypeField field = (RelDataTypeField)rowType.getFieldList().get(i);
            SqlTypeName sqlTypeName = field.getType().getSqlTypeName();
            ValueType valueType = Calcites.getValueTypeForSqlTypeName(sqlTypeName);
            if (valueType == null) {
                throw new ISE("Cannot translate sqlTypeName[%s] to Druid type for field[%s]", new Object[]{sqlTypeName, rowOrder.get(i)});
            }
            rowSignatureBuilder.add(rowOrder.get(i), valueType);
        }
        return rowSignatureBuilder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public ValueType getColumnType(String name) {
        return this.columnTypes.get(name);
    }

    public List<String> getRowOrder() {
        return this.columnNames;
    }

    @Nonnull
    public StringComparator naturalStringComparator(SimpleExtraction simpleExtraction) {
        Preconditions.checkNotNull((Object)simpleExtraction, (Object)"simpleExtraction");
        if (simpleExtraction.getExtractionFn() != null || this.getColumnType(simpleExtraction.getColumn()) == ValueType.STRING) {
            return StringComparators.LEXICOGRAPHIC;
        }
        return StringComparators.NUMERIC;
    }

    public RelDataType getRelDataType(RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        boolean nullNumeric = !NullHandling.replaceWithDefault();
        for (String columnName : this.columnNames) {
            RelDataType type;
            ValueType columnType = this.getColumnType(columnName);
            if ("__time".equals(columnName)) {
                type = Calcites.createSqlType(typeFactory, SqlTypeName.TIMESTAMP);
            } else {
                switch (columnType) {
                    case STRING: {
                        type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.VARCHAR, true);
                        break;
                    }
                    case LONG: {
                        type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.BIGINT, nullNumeric);
                        break;
                    }
                    case FLOAT: {
                        type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.FLOAT, nullNumeric);
                        break;
                    }
                    case DOUBLE: {
                        type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.DOUBLE, nullNumeric);
                        break;
                    }
                    case COMPLEX: {
                        type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.OTHER, true);
                        break;
                    }
                    default: {
                        throw new ISE("WTF?! valueType[%s] not translatable?", new Object[]{columnType});
                    }
                }
            }
            builder.add(columnName, type);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowSignature that = (RowSignature)o;
        if (this.columnTypes != null ? !this.columnTypes.equals(that.columnTypes) : that.columnTypes != null) {
            return false;
        }
        return this.columnNames != null ? this.columnNames.equals(that.columnNames) : that.columnNames == null;
    }

    public int hashCode() {
        int result = this.columnTypes != null ? this.columnTypes.hashCode() : 0;
        result = 31 * result + (this.columnNames != null ? this.columnNames.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (i > 0) {
                s.append(", ");
            }
            String columnName = this.columnNames.get(i);
            s.append(columnName).append(":").append(this.getColumnType(columnName));
        }
        return s.append("}").toString();
    }

    public static class Builder {
        private final List<Pair<String, ValueType>> columnTypeList = new ArrayList<Pair<String, ValueType>>();

        private Builder() {
        }

        public Builder add(String columnName, ValueType columnType) {
            Preconditions.checkNotNull((Object)columnName, (Object)"columnName");
            Preconditions.checkNotNull((Object)columnType, (Object)"columnType");
            this.columnTypeList.add((Pair<String, ValueType>)Pair.of((Object)columnName, (Object)columnType));
            return this;
        }

        public RowSignature build() {
            return new RowSignature(this.columnTypeList);
        }
    }
}

