/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.table.RowSignature;

public class InformationSchema
extends AbstractSchema {
    public static final String NAME = "INFORMATION_SCHEMA";
    private static final String CATALOG_NAME = "druid";
    private static final String SCHEMATA_TABLE = "SCHEMATA";
    private static final String TABLES_TABLE = "TABLES";
    private static final String COLUMNS_TABLE = "COLUMNS";
    private static final RowSignature SCHEMATA_SIGNATURE = RowSignature.builder().add("CATALOG_NAME", ValueType.STRING).add("SCHEMA_NAME", ValueType.STRING).add("SCHEMA_OWNER", ValueType.STRING).add("DEFAULT_CHARACTER_SET_CATALOG", ValueType.STRING).add("DEFAULT_CHARACTER_SET_SCHEMA", ValueType.STRING).add("DEFAULT_CHARACTER_SET_NAME", ValueType.STRING).add("SQL_PATH", ValueType.STRING).build();
    private static final RowSignature TABLES_SIGNATURE = RowSignature.builder().add("TABLE_CATALOG", ValueType.STRING).add("TABLE_SCHEMA", ValueType.STRING).add("TABLE_NAME", ValueType.STRING).add("TABLE_TYPE", ValueType.STRING).build();
    private static final RowSignature COLUMNS_SIGNATURE = RowSignature.builder().add("TABLE_CATALOG", ValueType.STRING).add("TABLE_SCHEMA", ValueType.STRING).add("TABLE_NAME", ValueType.STRING).add("COLUMN_NAME", ValueType.STRING).add("ORDINAL_POSITION", ValueType.STRING).add("COLUMN_DEFAULT", ValueType.STRING).add("IS_NULLABLE", ValueType.STRING).add("DATA_TYPE", ValueType.STRING).add("CHARACTER_MAXIMUM_LENGTH", ValueType.STRING).add("CHARACTER_OCTET_LENGTH", ValueType.STRING).add("NUMERIC_PRECISION", ValueType.STRING).add("NUMERIC_PRECISION_RADIX", ValueType.STRING).add("NUMERIC_SCALE", ValueType.STRING).add("DATETIME_PRECISION", ValueType.STRING).add("CHARACTER_SET_NAME", ValueType.STRING).add("COLLATION_NAME", ValueType.STRING).add("JDBC_TYPE", ValueType.LONG).build();
    private static final RelDataTypeSystem TYPE_SYSTEM = RelDataTypeSystem.DEFAULT;
    private static final Function<String, Iterable<ResourceAction>> DRUID_TABLE_RA_GENERATOR = datasourceName -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply(datasourceName));
    private final SchemaPlus rootSchema;
    private final Map<String, Table> tableMap;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public InformationSchema(SchemaPlus rootSchema, AuthorizerMapper authorizerMapper) {
        this.rootSchema = (SchemaPlus)Preconditions.checkNotNull((Object)rootSchema, (Object)"rootSchema");
        this.tableMap = ImmutableMap.of((Object)SCHEMATA_TABLE, (Object)((Object)new SchemataTable()), (Object)TABLES_TABLE, (Object)((Object)new TablesTable()), (Object)COLUMNS_TABLE, (Object)((Object)new ColumnsTable()));
        this.authorizerMapper = authorizerMapper;
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    @Nullable
    private static TableMacro getView(SchemaPlus schemaPlus, String functionName) {
        Collection functions = schemaPlus.getFunctions(functionName);
        for (org.apache.calcite.schema.Function function : functions) {
            if (!function.getParameters().isEmpty() || !(function instanceof TableMacro)) continue;
            return (TableMacro)function;
        }
        return null;
    }

    private Set<String> getAuthorizedTableNamesFromSubSchema(SchemaPlus subSchema, AuthenticationResult authenticationResult) {
        if (CATALOG_NAME.equals(subSchema.getName())) {
            return ImmutableSet.copyOf((Iterable)AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, (Iterable)subSchema.getTableNames(), DRUID_TABLE_RA_GENERATOR, (AuthorizerMapper)this.authorizerMapper));
        }
        return subSchema.getTableNames();
    }

    private Set<String> getAuthorizedFunctionNamesFromSubSchema(SchemaPlus subSchema, AuthenticationResult authenticationResult) {
        if (CATALOG_NAME.equals(subSchema.getName())) {
            return ImmutableSet.copyOf((Iterable)AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, (Iterable)subSchema.getFunctionNames(), DRUID_TABLE_RA_GENERATOR, (AuthorizerMapper)this.authorizerMapper));
        }
        return subSchema.getFunctionNames();
    }

    class ColumnsTable
    extends AbstractTable
    implements ScannableTable {
        ColumnsTable() {
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            FluentIterable results = FluentIterable.from((Iterable)InformationSchema.this.rootSchema.getSubSchemaNames()).transformAndConcat((Function)new Function<String, Iterable<Object[]>>(){

                public Iterable<Object[]> apply(final String schemaName) {
                    final SchemaPlus subSchema = InformationSchema.this.rootSchema.getSubSchema(schemaName);
                    final JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(TYPE_SYSTEM);
                    AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
                    Set authorizedTableNames = InformationSchema.this.getAuthorizedTableNamesFromSubSchema(subSchema, authenticationResult);
                    Set authorizedFunctionNames = InformationSchema.this.getAuthorizedFunctionNamesFromSubSchema(subSchema, authenticationResult);
                    return Iterables.concat((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)FluentIterable.from((Iterable)authorizedTableNames).transform((Function)new Function<String, Iterable<Object[]>>(){

                        public Iterable<Object[]> apply(String tableName) {
                            return ColumnsTable.this.generateColumnMetadata(schemaName, tableName, subSchema.getTable(tableName), (RelDataTypeFactory)typeFactory);
                        }
                    }), (Iterable)FluentIterable.from((Iterable)authorizedFunctionNames).transform((Function)new Function<String, Iterable<Object[]>>(){

                        public Iterable<Object[]> apply(String functionName) {
                            TableMacro viewMacro = InformationSchema.getView(subSchema, functionName);
                            if (viewMacro == null) {
                                return null;
                            }
                            return ColumnsTable.this.generateColumnMetadata(schemaName, functionName, (Table)viewMacro.apply((List)ImmutableList.of()), (RelDataTypeFactory)typeFactory);
                        }
                    })), (Predicate)Predicates.notNull()));
                }
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return COLUMNS_SIGNATURE.getRelDataType(typeFactory);
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        @Nullable
        private Iterable<Object[]> generateColumnMetadata(final String schemaName, final String tableName, Table table, RelDataTypeFactory typeFactory) {
            if (table == null) {
                return null;
            }
            return FluentIterable.from((Iterable)table.getRowType(typeFactory).getFieldList()).transform((Function)new Function<RelDataTypeField, Object[]>(){

                public Object[] apply(RelDataTypeField field) {
                    RelDataType type = field.getType();
                    boolean isNumeric = SqlTypeName.NUMERIC_TYPES.contains(type.getSqlTypeName());
                    boolean isCharacter = SqlTypeName.CHAR_TYPES.contains(type.getSqlTypeName());
                    boolean isDateTime = SqlTypeName.DATETIME_TYPES.contains(type.getSqlTypeName());
                    return new Object[]{InformationSchema.CATALOG_NAME, schemaName, tableName, field.getName(), String.valueOf(field.getIndex()), "", type.isNullable() ? "YES" : "NO", type.getSqlTypeName().toString(), null, null, isNumeric ? String.valueOf(type.getPrecision()) : null, isNumeric ? "10" : null, isNumeric ? String.valueOf(type.getScale()) : null, isDateTime ? String.valueOf(type.getPrecision()) : null, isCharacter ? type.getCharset().name() : null, isCharacter ? type.getCollation().getCollationName() : null, (long)type.getSqlTypeName().getJdbcOrdinal()};
                }
            });
        }
    }

    class TablesTable
    extends AbstractTable
    implements ScannableTable {
        TablesTable() {
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            FluentIterable results = FluentIterable.from((Iterable)InformationSchema.this.rootSchema.getSubSchemaNames()).transformAndConcat((Function)new Function<String, Iterable<Object[]>>(){

                public Iterable<Object[]> apply(final String schemaName) {
                    final SchemaPlus subSchema = InformationSchema.this.rootSchema.getSubSchema(schemaName);
                    AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
                    Set authorizedTableNames = InformationSchema.this.getAuthorizedTableNamesFromSubSchema(subSchema, authenticationResult);
                    Set authorizedFunctionNames = InformationSchema.this.getAuthorizedFunctionNamesFromSubSchema(subSchema, authenticationResult);
                    return Iterables.filter((Iterable)Iterables.concat((Iterable)FluentIterable.from((Iterable)authorizedTableNames).transform((Function)new Function<String, Object[]>(){

                        public Object[] apply(String tableName) {
                            return new Object[]{InformationSchema.CATALOG_NAME, schemaName, tableName, subSchema.getTable(tableName).getJdbcTableType().toString()};
                        }
                    }), (Iterable)FluentIterable.from((Iterable)authorizedFunctionNames).transform((Function)new Function<String, Object[]>(){

                        public Object[] apply(String functionName) {
                            if (InformationSchema.getView(subSchema, functionName) != null) {
                                return new Object[]{InformationSchema.CATALOG_NAME, schemaName, functionName, "VIEW"};
                            }
                            return null;
                        }
                    })), (Predicate)Predicates.notNull());
                }
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return TABLES_SIGNATURE.getRelDataType(typeFactory);
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }
    }

    class SchemataTable
    extends AbstractTable
    implements ScannableTable {
        SchemataTable() {
        }

        public Enumerable<Object[]> scan(DataContext root) {
            FluentIterable results = FluentIterable.from((Iterable)InformationSchema.this.rootSchema.getSubSchemaNames()).transform((Function)new Function<String, Object[]>(){

                public Object[] apply(String schemaName) {
                    SchemaPlus subSchema = InformationSchema.this.rootSchema.getSubSchema(schemaName);
                    return new Object[]{InformationSchema.CATALOG_NAME, subSchema.getName(), null, null, null, null, null};
                }
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return SCHEMATA_SIGNATURE.getRelDataType(typeFactory);
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }
    }
}

