/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.rel.DruidOuterQueryRel;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rule.DruidSortUnionRule;
import org.apache.druid.sql.calcite.rule.DruidUnionRule;

public class DruidRules {
    public static final Predicate<DruidRel> CAN_BUILD_ON = druidRel -> druidRel.getPartialDruidQuery() != null;

    private DruidRules() {
    }

    public static List<RelOptRule> rules() {
        return ImmutableList.of(new DruidQueryRule<Filter>(Filter.class, PartialDruidQuery.Stage.WHERE_FILTER, PartialDruidQuery::withWhereFilter), new DruidQueryRule<Project>(Project.class, PartialDruidQuery.Stage.SELECT_PROJECT, PartialDruidQuery::withSelectProject), new DruidQueryRule<Aggregate>(Aggregate.class, PartialDruidQuery.Stage.AGGREGATE, PartialDruidQuery::withAggregate), new DruidQueryRule<Project>(Project.class, PartialDruidQuery.Stage.AGGREGATE_PROJECT, PartialDruidQuery::withAggregateProject), new DruidQueryRule<Filter>(Filter.class, PartialDruidQuery.Stage.HAVING_FILTER, PartialDruidQuery::withHavingFilter), new DruidQueryRule<Sort>(Sort.class, PartialDruidQuery.Stage.SORT, PartialDruidQuery::withSort), new DruidQueryRule<Project>(Project.class, PartialDruidQuery.Stage.SORT_PROJECT, PartialDruidQuery::withSortProject), (Object)DruidOuterQueryRule.AGGREGATE, (Object)DruidOuterQueryRule.FILTER_AGGREGATE, (Object)DruidOuterQueryRule.FILTER_PROJECT_AGGREGATE, (Object)DruidOuterQueryRule.PROJECT_AGGREGATE, (Object)DruidOuterQueryRule.AGGREGATE_SORT_PROJECT, (Object[])new RelOptRule[]{DruidUnionRule.instance(), DruidSortUnionRule.instance()});
    }

    public static abstract class DruidOuterQueryRule
    extends RelOptRule {
        public static final RelOptRule AGGREGATE = new DruidOuterQueryRule(DruidOuterQueryRule.operand(Aggregate.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "AGGREGATE"){

            public void onMatch(RelOptRuleCall call) {
                Aggregate aggregate = (Aggregate)call.rel(0);
                DruidRel druidRel = (DruidRel)call.rel(1);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.create(druidRel.getPartialDruidQuery().leafRel()).withAggregate(aggregate));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule FILTER_AGGREGATE = new DruidOuterQueryRule(DruidOuterQueryRule.operand(Aggregate.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(Filter.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "FILTER_AGGREGATE"){

            public void onMatch(RelOptRuleCall call) {
                Aggregate aggregate = (Aggregate)call.rel(0);
                Filter filter = (Filter)call.rel(1);
                DruidRel druidRel = (DruidRel)call.rel(2);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.create(druidRel.getPartialDruidQuery().leafRel()).withWhereFilter(filter).withAggregate(aggregate));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule FILTER_PROJECT_AGGREGATE = new DruidOuterQueryRule(DruidOuterQueryRule.operand(Aggregate.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(Project.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(Filter.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "FILTER_PROJECT_AGGREGATE"){

            public void onMatch(RelOptRuleCall call) {
                Aggregate aggregate = (Aggregate)call.rel(0);
                Project project = (Project)call.rel(1);
                Filter filter = (Filter)call.rel(2);
                DruidRel druidRel = (DruidRel)call.rel(3);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.create(druidRel.getPartialDruidQuery().leafRel()).withWhereFilter(filter).withSelectProject(project).withAggregate(aggregate));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule PROJECT_AGGREGATE = new DruidOuterQueryRule(DruidOuterQueryRule.operand(Aggregate.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(Project.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "PROJECT_AGGREGATE"){

            public void onMatch(RelOptRuleCall call) {
                Aggregate aggregate = (Aggregate)call.rel(0);
                Project project = (Project)call.rel(1);
                DruidRel druidRel = (DruidRel)call.rel(2);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.create(druidRel.getPartialDruidQuery().leafRel()).withSelectProject(project).withAggregate(aggregate));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule AGGREGATE_SORT_PROJECT = new DruidOuterQueryRule(DruidOuterQueryRule.operand(Project.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(Sort.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(Aggregate.class, (RelOptRuleOperand)DruidOuterQueryRule.operand(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "AGGREGATE_SORT_PROJECT"){

            public void onMatch(RelOptRuleCall call) {
                Project sortProject = (Project)call.rel(0);
                Sort sort = (Sort)call.rel(1);
                Aggregate aggregate = (Aggregate)call.rel(2);
                DruidRel druidRel = (DruidRel)call.rel(3);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.create(druidRel.getPartialDruidQuery().leafRel()).withAggregate(aggregate).withSort(sort).withSortProject(sortProject));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };

        public DruidOuterQueryRule(RelOptRuleOperand op, String description) {
            super(op, StringUtils.format((String)"%s(%s)", (Object[])new Object[]{DruidOuterQueryRel.class.getSimpleName(), description}));
        }

        public boolean matches(RelOptRuleCall call) {
            DruidRel druidRel = (DruidRel)call.rel(call.getRelList().size() - 1);
            return druidRel.getPartialDruidQuery().stage().compareTo(PartialDruidQuery.Stage.AGGREGATE) >= 0;
        }
    }

    public static class DruidQueryRule<RelType extends RelNode>
    extends RelOptRule {
        private final PartialDruidQuery.Stage stage;
        private final BiFunction<PartialDruidQuery, RelType, PartialDruidQuery> f;

        public DruidQueryRule(Class<RelType> relClass, PartialDruidQuery.Stage stage, BiFunction<PartialDruidQuery, RelType, PartialDruidQuery> f) {
            super(DruidQueryRule.operand(relClass, (RelOptRuleOperand)DruidQueryRule.operand(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), StringUtils.format((String)"%s(%s)", (Object[])new Object[]{DruidQueryRule.class.getSimpleName(), stage}));
            this.stage = stage;
            this.f = f;
        }

        public boolean matches(RelOptRuleCall call) {
            DruidRel druidRel = (DruidRel)call.rel(1);
            return druidRel.getPartialDruidQuery().canAccept(this.stage);
        }

        public void onMatch(RelOptRuleCall call) {
            PartialDruidQuery newPartialDruidQuery;
            RelNode otherRel = call.rel(0);
            DruidRel druidRel = (DruidRel)call.rel(1);
            Object newDruidRel = druidRel.withPartialQuery(newPartialDruidQuery = this.f.apply(druidRel.getPartialDruidQuery(), otherRel));
            if (((DruidRel)((Object)newDruidRel)).isValidDruidQuery()) {
                call.transformTo(newDruidRel);
            }
        }
    }
}

