/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidConformance;
import org.apache.druid.sql.calcite.planner.DruidConvertletTable;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.DruidRexExecutor;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.Rules;
import org.apache.druid.sql.calcite.rel.QueryMaker;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.SystemSchema;

public class PlannerFactory {
    private static final SqlParser.Config PARSER_CONFIG = SqlParser.configBuilder().setCaseSensitive(true).setUnquotedCasing(Casing.UNCHANGED).setQuotedCasing(Casing.UNCHANGED).setQuoting(Quoting.DOUBLE_QUOTE).setConformance((SqlConformance)DruidConformance.instance()).build();
    private final DruidSchema druidSchema;
    private final SystemSchema systemSchema;
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final DruidOperatorTable operatorTable;
    private final ExprMacroTable macroTable;
    private final PlannerConfig plannerConfig;
    private final ObjectMapper jsonMapper;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public PlannerFactory(DruidSchema druidSchema, SystemSchema systemSchema, QueryLifecycleFactory queryLifecycleFactory, DruidOperatorTable operatorTable, ExprMacroTable macroTable, PlannerConfig plannerConfig, AuthorizerMapper authorizerMapper, @Json ObjectMapper jsonMapper) {
        this.druidSchema = druidSchema;
        this.systemSchema = systemSchema;
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.operatorTable = operatorTable;
        this.macroTable = macroTable;
        this.plannerConfig = plannerConfig;
        this.authorizerMapper = authorizerMapper;
        this.jsonMapper = jsonMapper;
    }

    public DruidPlanner createPlanner(Map<String, Object> queryContext, AuthenticationResult authenticationResult) {
        SchemaPlus rootSchema = Calcites.createRootSchema(this.druidSchema, this.systemSchema, this.authorizerMapper);
        PlannerContext plannerContext = PlannerContext.create(this.operatorTable, this.macroTable, this.plannerConfig, queryContext, authenticationResult);
        QueryMaker queryMaker = new QueryMaker(this.queryLifecycleFactory, plannerContext, this.jsonMapper);
        SqlToRelConverter.Config sqlToRelConverterConfig = SqlToRelConverter.configBuilder().withExpand(false).withDecorrelationEnabled(false).withTrimUnusedFields(false).withInSubQueryThreshold(Integer.MAX_VALUE).build();
        FrameworkConfig frameworkConfig = Frameworks.newConfigBuilder().parserConfig(PARSER_CONFIG).traitDefs(new RelTraitDef[]{ConventionTraitDef.INSTANCE, RelCollationTraitDef.INSTANCE}).convertletTable((SqlRexConvertletTable)new DruidConvertletTable(plannerContext)).operatorTable((SqlOperatorTable)this.operatorTable).programs(Rules.programs(plannerContext, queryMaker)).executor((RexExecutor)new DruidRexExecutor(plannerContext)).context((Context)Contexts.EMPTY_CONTEXT).typeSystem((RelDataTypeSystem)DruidTypeSystem.INSTANCE).defaultSchema(rootSchema.getSubSchema("druid")).sqlToRelConverterConfig(sqlToRelConverterConfig).context(new Context(){

            public <C> C unwrap(Class<C> aClass) {
                if (aClass.equals(CalciteConnectionConfig.class)) {
                    Properties props = new Properties();
                    return (C)new CalciteConnectionConfigImpl(props){

                        public <T> T typeSystem(Class<T> typeSystemClass, T defaultTypeSystem) {
                            return (T)DruidTypeSystem.INSTANCE;
                        }

                        public SqlConformance conformance() {
                            return DruidConformance.instance();
                        }
                    };
                }
                return null;
            }
        }).build();
        return new DruidPlanner(Frameworks.getPlanner((FrameworkConfig)frameworkConfig), plannerContext);
    }

    public AuthorizerMapper getAuthorizerMapper() {
        return this.authorizerMapper;
    }
}

