/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;
import org.joda.time.DateTimeZone;

public class TimeFormatOperatorConversion
implements SqlOperatorConversion {
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("TIME_FORMAT").operandTypes(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).requiredOperands(1).returnType(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.TIMEDATE).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        RexNode timeArg = (RexNode)call.getOperands().get(0);
        DruidExpression timeExpression = Expressions.toDruidExpression(plannerContext, rowSignature, timeArg);
        if (timeExpression == null) {
            return null;
        }
        String pattern = OperatorConversions.getOperandWithDefault(call.getOperands(), 1, RexLiteral::stringValue, DEFAULT_PATTERN);
        DateTimeZone timeZone = OperatorConversions.getOperandWithDefault(call.getOperands(), 2, operand -> DateTimes.inferTzFromString((String)RexLiteral.stringValue((RexNode)operand)), plannerContext.getTimeZone());
        return DruidExpression.fromFunctionCall("timestamp_format", ImmutableList.of((Object)timeExpression.getExpression(), (Object)DruidExpression.stringLiteral(pattern), (Object)DruidExpression.stringLiteral(timeZone.getID())).stream().map(DruidExpression::fromExpression).collect(Collectors.toList()));
    }
}

