/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.query.expression.TimestampExtractExprMacro;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeExtractOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class ExtractOperatorConversion
implements SqlOperatorConversion {
    private static final Map<TimeUnitRange, TimestampExtractExprMacro.Unit> EXTRACT_UNIT_MAP = ImmutableMap.builder().put((Object)TimeUnitRange.EPOCH, (Object)TimestampExtractExprMacro.Unit.EPOCH).put((Object)TimeUnitRange.MICROSECOND, (Object)TimestampExtractExprMacro.Unit.MICROSECOND).put((Object)TimeUnitRange.MILLISECOND, (Object)TimestampExtractExprMacro.Unit.MILLISECOND).put((Object)TimeUnitRange.SECOND, (Object)TimestampExtractExprMacro.Unit.SECOND).put((Object)TimeUnitRange.MINUTE, (Object)TimestampExtractExprMacro.Unit.MINUTE).put((Object)TimeUnitRange.HOUR, (Object)TimestampExtractExprMacro.Unit.HOUR).put((Object)TimeUnitRange.DAY, (Object)TimestampExtractExprMacro.Unit.DAY).put((Object)TimeUnitRange.DOW, (Object)TimestampExtractExprMacro.Unit.DOW).put((Object)TimeUnitRange.ISODOW, (Object)TimestampExtractExprMacro.Unit.ISODOW).put((Object)TimeUnitRange.DOY, (Object)TimestampExtractExprMacro.Unit.DOY).put((Object)TimeUnitRange.WEEK, (Object)TimestampExtractExprMacro.Unit.WEEK).put((Object)TimeUnitRange.MONTH, (Object)TimestampExtractExprMacro.Unit.MONTH).put((Object)TimeUnitRange.QUARTER, (Object)TimestampExtractExprMacro.Unit.QUARTER).put((Object)TimeUnitRange.YEAR, (Object)TimestampExtractExprMacro.Unit.YEAR).put((Object)TimeUnitRange.ISOYEAR, (Object)TimestampExtractExprMacro.Unit.ISOYEAR).put((Object)TimeUnitRange.DECADE, (Object)TimestampExtractExprMacro.Unit.DECADE).put((Object)TimeUnitRange.CENTURY, (Object)TimestampExtractExprMacro.Unit.CENTURY).put((Object)TimeUnitRange.MILLENNIUM, (Object)TimestampExtractExprMacro.Unit.MILLENNIUM).build();

    public SqlFunction calciteOperator() {
        return SqlStdOperatorTable.EXTRACT;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        RexLiteral flag = (RexLiteral)call.getOperands().get(0);
        TimeUnitRange calciteUnit = (TimeUnitRange)flag.getValue();
        RexNode arg = (RexNode)call.getOperands().get(1);
        DruidExpression input = Expressions.toDruidExpression(plannerContext, rowSignature, arg);
        if (input == null) {
            return null;
        }
        TimestampExtractExprMacro.Unit druidUnit = EXTRACT_UNIT_MAP.get(calciteUnit);
        if (druidUnit == null) {
            return null;
        }
        return TimeExtractOperatorConversion.applyTimeExtract(input, druidUnit, plannerContext.getTimeZone());
    }
}

