/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TrimOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class BTrimOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("BTRIM").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).returnType(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.STRING).requiredOperands(1).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> {
            if (druidExpressions.size() > 1) {
                return TrimOperatorConversion.makeTrimExpression(SqlTrimFunction.Flag.BOTH, (DruidExpression)druidExpressions.get(0), (DruidExpression)druidExpressions.get(1));
            }
            return TrimOperatorConversion.makeTrimExpression(SqlTrimFunction.Flag.BOTH, (DruidExpression)druidExpressions.get(0), DruidExpression.fromExpression(DruidExpression.stringLiteral(" ")));
        });
    }
}

