/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.server.QueryStats;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.joda.time.DateTime;

public class SqlLifecycle {
    private static final Logger log = new Logger(SqlLifecycle.class);
    private final PlannerFactory plannerFactory;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final long startMs;
    private final long startNs;
    private final Object lock = new Object();
    private State state = State.NEW;
    private String sql;
    private Map<String, Object> queryContext;
    @Nullable
    private HttpServletRequest req;
    private PlannerContext plannerContext;
    private PlannerResult plannerResult;

    public SqlLifecycle(PlannerFactory plannerFactory, ServiceEmitter emitter, RequestLogger requestLogger, long startMs, long startNs) {
        this.plannerFactory = plannerFactory;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.startMs = startMs;
        this.startNs = startNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String initialize(String sql, Map<String, Object> queryContext) {
        Object object = this.lock;
        synchronized (object) {
            this.transition(State.NEW, State.INITIALIZED);
            this.sql = sql;
            this.queryContext = this.contextWithSqlId(queryContext);
            return this.sqlQueryId();
        }
    }

    private Map<String, Object> contextWithSqlId(Map<String, Object> queryContext) {
        HashMap<String, Object> newContext = new HashMap<String, Object>();
        if (queryContext != null) {
            newContext.putAll(queryContext);
        }
        newContext.computeIfAbsent("sqlQueryId", k -> UUID.randomUUID().toString());
        return newContext;
    }

    private String sqlQueryId() {
        return (String)this.queryContext.get("sqlQueryId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlannerContext plan(AuthenticationResult authenticationResult) throws ValidationException, RelConversionException, SqlParseException {
        Object object = this.lock;
        synchronized (object) {
            this.transition(State.INITIALIZED, State.PLANNED);
            try (DruidPlanner planner = this.plannerFactory.createPlanner(this.queryContext, authenticationResult);){
                this.plannerContext = planner.getPlannerContext();
                this.plannerResult = planner.plan(this.sql);
            }
            return this.plannerContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlannerContext plan(HttpServletRequest req) throws SqlParseException, RelConversionException, ValidationException {
        Object object = this.lock;
        synchronized (object) {
            this.req = req;
            return this.plan(AuthorizationUtils.authenticationResultFromRequest((HttpServletRequest)req));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelDataType rowType() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.plannerResult != null ? 1 : 0) != 0, (Object)"must be called after sql has been planned");
            return this.plannerResult.rowType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Access authorize() {
        Object object = this.lock;
        synchronized (object) {
            this.transition(State.PLANNED, State.AUTHORIZING);
            if (this.req != null) {
                return this.doAuthorize(AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)this.req, (Iterable)Iterables.transform(this.plannerResult.datasourceNames(), (Function)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR), (AuthorizerMapper)this.plannerFactory.getAuthorizerMapper()));
            }
            return this.doAuthorize(AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)this.plannerContext.getAuthenticationResult(), (Iterable)Iterables.transform(this.plannerResult.datasourceNames(), (Function)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR), (AuthorizerMapper)this.plannerFactory.getAuthorizerMapper()));
        }
    }

    private Access doAuthorize(Access authorizationResult) {
        if (!authorizationResult.isAllowed()) {
            this.transition(State.AUTHORIZING, State.UNAUTHORIZED);
        } else {
            this.transition(State.AUTHORIZING, State.AUTHORIZED);
        }
        return authorizationResult;
    }

    public PlannerContext planAndAuthorize(AuthenticationResult authenticationResult) throws SqlParseException, RelConversionException, ValidationException {
        PlannerContext plannerContext = this.plan(authenticationResult);
        Access access = this.authorize();
        if (!access.isAllowed()) {
            throw new ForbiddenException(access.toString());
        }
        return plannerContext;
    }

    public PlannerContext planAndAuthorize(HttpServletRequest req) throws SqlParseException, RelConversionException, ValidationException {
        PlannerContext plannerContext = this.plan(req);
        Access access = this.authorize();
        if (!access.isAllowed()) {
            throw new ForbiddenException(access.toString());
        }
        return plannerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence<Object[]> execute() {
        Object object = this.lock;
        synchronized (object) {
            this.transition(State.AUTHORIZED, State.EXECUTING);
            return this.plannerResult.run();
        }
    }

    public Sequence<Object[]> runSimple(String sql, Map<String, Object> queryContext, AuthenticationResult authenticationResult) throws ValidationException, RelConversionException, SqlParseException {
        Sequence<Object[]> result;
        this.initialize(sql, queryContext);
        try {
            this.planAndAuthorize(authenticationResult);
            result = this.execute();
        }
        catch (Throwable e) {
            this.emitLogsAndMetrics(e, null, -1L);
            throw e;
        }
        return Sequences.wrap(result, (SequenceWrapper)new SequenceWrapper(){

            public void after(boolean isDone, Throwable thrown) {
                SqlLifecycle.this.emitLogsAndMetrics(thrown, null, -1L);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitLogsAndMetrics(@Nullable Throwable e, @Nullable String remoteAddress, long bytesWritten) {
        Object object = this.lock;
        synchronized (object) {
            if (this.sql == null) {
                return;
            }
            if (this.state == State.DONE) {
                log.warn("Tried to emit logs and metrics twice for query[%s]!", new Object[]{this.sqlQueryId()});
            }
            this.state = State.DONE;
            boolean success = e == null;
            long queryTimeNs = System.nanoTime() - this.startNs;
            try {
                ServiceMetricEvent.Builder metricBuilder = ServiceMetricEvent.builder();
                if (this.plannerContext != null) {
                    metricBuilder.setDimension("id", (Object)this.plannerContext.getSqlQueryId());
                    metricBuilder.setDimension("nativeQueryIds", (Object)this.plannerContext.getNativeQueryIds().toString());
                }
                if (this.plannerResult != null) {
                    metricBuilder.setDimension("dataSource", (Object)this.plannerResult.datasourceNames().toString());
                }
                metricBuilder.setDimension("remoteAddress", (Object)StringUtils.nullToEmptyNonDruidDataString((String)remoteAddress));
                metricBuilder.setDimension("success", (Object)String.valueOf(success));
                this.emitter.emit(metricBuilder.build("sqlQuery/time", (Number)TimeUnit.NANOSECONDS.toMillis(queryTimeNs)));
                if (bytesWritten >= 0L) {
                    this.emitter.emit(metricBuilder.build("sqlQuery/bytes", (Number)bytesWritten));
                }
                LinkedHashMap<String, Object> statsMap = new LinkedHashMap<String, Object>();
                statsMap.put("sqlQuery/time", TimeUnit.NANOSECONDS.toMillis(queryTimeNs));
                statsMap.put("sqlQuery/bytes", bytesWritten);
                statsMap.put("success", success);
                statsMap.put("context", this.queryContext);
                if (this.plannerContext != null) {
                    statsMap.put("identity", this.plannerContext.getAuthenticationResult().getIdentity());
                    this.queryContext.put("nativeQueryIds", this.plannerContext.getNativeQueryIds().toString());
                }
                if (e != null) {
                    statsMap.put("exception", e.toString());
                    if (e instanceof QueryInterruptedException) {
                        statsMap.put("interrupted", true);
                        statsMap.put("reason", e.toString());
                    }
                }
                this.requestLogger.logSqlQuery(RequestLogLine.forSql((String)this.sql, this.queryContext, (DateTime)DateTimes.utc((long)this.startMs), (String)remoteAddress, (QueryStats)new QueryStats(statsMap)));
            }
            catch (Exception ex) {
                log.error((Throwable)ex, "Unable to log sql [%s]!", new Object[]{this.sql});
            }
        }
    }

    private void transition(State from, State to) {
        if (this.state != from) {
            throw new ISE("Cannot transition from[%s] to[%s] because current state[%s] is not [%s].", new Object[]{from, to, this.state, from});
        }
        this.state = to;
    }

    static enum State {
        NEW,
        INITIALIZED,
        PLANNED,
        AUTHORIZING,
        AUTHORIZED,
        EXECUTING,
        UNAUTHORIZED,
        DONE;

    }
}

