/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.inject.Inject;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Map;
import org.apache.druid.client.DruidServerConfig;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.timeline.DataSegment;

public class HistoricalMetricsMonitor
extends AbstractMonitor {
    private final DruidServerConfig serverConfig;
    private final SegmentManager segmentManager;
    private final SegmentLoadDropHandler segmentLoadDropMgr;

    @Inject
    public HistoricalMetricsMonitor(DruidServerConfig serverConfig, SegmentManager segmentManager, SegmentLoadDropHandler segmentLoadDropMgr) {
        this.serverConfig = serverConfig;
        this.segmentManager = segmentManager;
        this.segmentLoadDropMgr = segmentLoadDropMgr;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        String dataSource;
        emitter.emit(new ServiceMetricEvent.Builder().build("segment/max", (Number)this.serverConfig.getMaxSize()));
        Object2LongOpenHashMap pendingDeleteSizes = new Object2LongOpenHashMap();
        for (DataSegment dataSegment : this.segmentLoadDropMgr.getPendingDeleteSnapshot()) {
            pendingDeleteSizes.addTo((Object)dataSegment.getDataSource(), dataSegment.getSize());
        }
        for (Object2LongMap.Entry entry : pendingDeleteSizes.object2LongEntrySet()) {
            dataSource = (String)entry.getKey();
            long pendingDeleteSize = entry.getLongValue();
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", (Object)dataSource).setDimension("tier", (Object)this.serverConfig.getTier()).setDimension("priority", (Object)String.valueOf(this.serverConfig.getPriority())).build("segment/pendingDelete", (Number)pendingDeleteSize));
        }
        for (Map.Entry entry : this.segmentManager.getDataSourceSizes().entrySet()) {
            dataSource = (String)entry.getKey();
            long used = (Long)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("dataSource", (Object)dataSource).setDimension("tier", (Object)this.serverConfig.getTier()).setDimension("priority", (Object)String.valueOf(this.serverConfig.getPriority()));
            emitter.emit(builder.build("segment/used", (Number)used));
            double usedPercent = this.serverConfig.getMaxSize() == 0L ? 0.0 : (double)used / (double)this.serverConfig.getMaxSize();
            emitter.emit(builder.build("segment/usedPercent", (Number)usedPercent));
        }
        for (Map.Entry entry : this.segmentManager.getDataSourceCounts().entrySet()) {
            dataSource = (String)entry.getKey();
            long count = (Long)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("dataSource", (Object)dataSource).setDimension("tier", (Object)this.serverConfig.getTier()).setDimension("priority", (Object)String.valueOf(this.serverConfig.getPriority()));
            emitter.emit(builder.build("segment/count", (Number)count));
        }
        return true;
    }
}

