/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.common.utils.ServletResourceUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.joda.time.Interval;

@Path(value="/druid/coordinator/v1/config")
@ResourceFilters(value={ConfigResourceFilter.class})
public class CoordinatorDynamicConfigsResource {
    private final JacksonConfigManager manager;
    private final AuditManager auditManager;

    @Inject
    public CoordinatorDynamicConfigsResource(JacksonConfigManager manager, AuditManager auditManager) {
        this.manager = manager;
        this.auditManager = auditManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDynamicConfigs() {
        return Response.ok((Object)CoordinatorDynamicConfig.current(this.manager)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response setDynamicConfigs(CoordinatorDynamicConfig.Builder dynamicConfigBuilder, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        try {
            CoordinatorDynamicConfig current = CoordinatorDynamicConfig.current(this.manager);
            ConfigManager.SetResult setResult = this.manager.set("coordinator.config", (Object)dynamicConfigBuilder.build(current), new AuditInfo(author, comment, req.getRemoteAddr()));
            if (setResult.isOk()) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)setResult.getException())).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @GET
    @Path(value="/history")
    @Produces(value={"application/json"})
    public Response getDatasourceRuleHistory(@QueryParam(value="interval") String interval, @QueryParam(value="count") Integer count) {
        Interval theInterval;
        Interval interval2 = theInterval = interval == null ? null : Intervals.of((String)interval);
        if (theInterval == null && count != null) {
            try {
                return Response.ok((Object)this.auditManager.fetchAuditHistory("coordinator.config", "coordinator.config", count.intValue())).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
            }
        }
        return Response.ok((Object)this.auditManager.fetchAuditHistory("coordinator.config", "coordinator.config", theInterval)).build();
    }
}

