/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class SegmentReplicantLookup {
    private final Table<SegmentId, String, Integer> segmentsInCluster;
    private final Table<SegmentId, String, Integer> loadingSegments;

    public static SegmentReplicantLookup make(DruidCluster cluster) {
        HashBasedTable segmentsInCluster = HashBasedTable.create();
        HashBasedTable loadingSegments = HashBasedTable.create();
        for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : sortedSet) {
                Integer numReplicants;
                ImmutableDruidServer server = serverHolder.getServer();
                for (DataSegment segment : server.iterateAllSegments()) {
                    numReplicants = (Integer)segmentsInCluster.get((Object)segment.getId(), (Object)server.getTier());
                    if (numReplicants == null) {
                        numReplicants = 0;
                    }
                    segmentsInCluster.put((Object)segment.getId(), (Object)server.getTier(), (Object)(numReplicants + 1));
                }
                for (DataSegment segment : serverHolder.getPeon().getSegmentsToLoad()) {
                    numReplicants = (Integer)loadingSegments.get((Object)segment.getId(), (Object)server.getTier());
                    if (numReplicants == null) {
                        numReplicants = 0;
                    }
                    loadingSegments.put((Object)segment.getId(), (Object)server.getTier(), (Object)(numReplicants + 1));
                }
            }
        }
        return new SegmentReplicantLookup((Table<SegmentId, String, Integer>)segmentsInCluster, (Table<SegmentId, String, Integer>)loadingSegments);
    }

    private SegmentReplicantLookup(Table<SegmentId, String, Integer> segmentsInCluster, Table<SegmentId, String, Integer> loadingSegments) {
        this.segmentsInCluster = segmentsInCluster;
        this.loadingSegments = loadingSegments;
    }

    public Map<String, Integer> getClusterTiers(SegmentId segmentId) {
        Map retVal = this.segmentsInCluster.row((Object)segmentId);
        return retVal == null ? new HashMap() : retVal;
    }

    int getLoadedReplicants(SegmentId segmentId) {
        Map allTiers = this.segmentsInCluster.row((Object)segmentId);
        int retVal = 0;
        for (Integer replicants : allTiers.values()) {
            retVal += replicants.intValue();
        }
        return retVal;
    }

    int getLoadedReplicants(SegmentId segmentId, String tier) {
        Integer retVal = (Integer)this.segmentsInCluster.get((Object)segmentId, (Object)tier);
        return retVal == null ? 0 : retVal;
    }

    private int getLoadingReplicants(SegmentId segmentId, String tier) {
        Integer retVal = (Integer)this.loadingSegments.get((Object)segmentId, (Object)tier);
        return retVal == null ? 0 : retVal;
    }

    private int getLoadingReplicants(SegmentId segmentId) {
        Map allTiers = this.loadingSegments.row((Object)segmentId);
        int retVal = 0;
        for (Integer replicants : allTiers.values()) {
            retVal += replicants.intValue();
        }
        return retVal;
    }

    public int getTotalReplicants(SegmentId segmentId) {
        return this.getLoadedReplicants(segmentId) + this.getLoadingReplicants(segmentId);
    }

    public int getTotalReplicants(SegmentId segmentId, String tier) {
        return this.getLoadedReplicants(segmentId, tier) + this.getLoadingReplicants(segmentId, tier);
    }
}

