/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.ReplicationThrottler;
import org.apache.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.DateTime;

public class DruidCoordinatorRuntimeParams {
    private final long startTimeNanos;
    private final DruidCluster druidCluster;
    private final MetadataRuleManager databaseRuleManager;
    private final SegmentReplicantLookup segmentReplicantLookup;
    @Nullable
    private final TreeSet<DataSegment> usedSegments;
    @Nullable
    private final DataSourcesSnapshot dataSourcesSnapshot;
    private final Map<String, LoadQueuePeon> loadManagementPeons;
    private final ReplicationThrottler replicationManager;
    private final ServiceEmitter emitter;
    private final CoordinatorDynamicConfig coordinatorDynamicConfig;
    private final CoordinatorCompactionConfig coordinatorCompactionConfig;
    private final CoordinatorStats stats;
    private final DateTime balancerReferenceTimestamp;
    private final BalancerStrategy balancerStrategy;

    private static TreeSet<DataSegment> createUsedSegmentsSet(Iterable<DataSegment> usedSegments) {
        TreeSet<DataSegment> segmentsSet = new TreeSet<DataSegment>(DruidCoordinator.SEGMENT_COMPARATOR_RECENT_FIRST);
        usedSegments.forEach(segmentsSet::add);
        return segmentsSet;
    }

    private DruidCoordinatorRuntimeParams(long startTimeNanos, DruidCluster druidCluster, MetadataRuleManager databaseRuleManager, SegmentReplicantLookup segmentReplicantLookup, @Nullable TreeSet<DataSegment> usedSegments, @Nullable DataSourcesSnapshot dataSourcesSnapshot, Map<String, LoadQueuePeon> loadManagementPeons, ReplicationThrottler replicationManager, ServiceEmitter emitter, CoordinatorDynamicConfig coordinatorDynamicConfig, CoordinatorCompactionConfig coordinatorCompactionConfig, CoordinatorStats stats, DateTime balancerReferenceTimestamp, BalancerStrategy balancerStrategy) {
        this.startTimeNanos = startTimeNanos;
        this.druidCluster = druidCluster;
        this.databaseRuleManager = databaseRuleManager;
        this.segmentReplicantLookup = segmentReplicantLookup;
        this.usedSegments = usedSegments;
        this.dataSourcesSnapshot = dataSourcesSnapshot;
        this.loadManagementPeons = loadManagementPeons;
        this.replicationManager = replicationManager;
        this.emitter = emitter;
        this.coordinatorDynamicConfig = coordinatorDynamicConfig;
        this.coordinatorCompactionConfig = coordinatorCompactionConfig;
        this.stats = stats;
        this.balancerReferenceTimestamp = balancerReferenceTimestamp;
        this.balancerStrategy = balancerStrategy;
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public DruidCluster getDruidCluster() {
        return this.druidCluster;
    }

    public MetadataRuleManager getDatabaseRuleManager() {
        return this.databaseRuleManager;
    }

    public SegmentReplicantLookup getSegmentReplicantLookup() {
        return this.segmentReplicantLookup;
    }

    public Map<String, VersionedIntervalTimeline<String, DataSegment>> getUsedSegmentsTimelinesPerDataSource() {
        Preconditions.checkState((this.dataSourcesSnapshot != null ? 1 : 0) != 0, (Object)"dataSourcesSnapshot or usedSegments must be set");
        return this.dataSourcesSnapshot.getUsedSegmentsTimelinesPerDataSource();
    }

    public TreeSet<DataSegment> getUsedSegments() {
        Preconditions.checkState((this.usedSegments != null ? 1 : 0) != 0, (Object)"usedSegments or dataSourcesSnapshot must be set");
        return this.usedSegments;
    }

    public Map<String, LoadQueuePeon> getLoadManagementPeons() {
        return this.loadManagementPeons;
    }

    public ReplicationThrottler getReplicationManager() {
        return this.replicationManager;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public CoordinatorDynamicConfig getCoordinatorDynamicConfig() {
        return this.coordinatorDynamicConfig;
    }

    public CoordinatorCompactionConfig getCoordinatorCompactionConfig() {
        return this.coordinatorCompactionConfig;
    }

    public CoordinatorStats getCoordinatorStats() {
        return this.stats;
    }

    public DateTime getBalancerReferenceTimestamp() {
        return this.balancerReferenceTimestamp;
    }

    public BalancerStrategy getBalancerStrategy() {
        return this.balancerStrategy;
    }

    public boolean coordinatorIsLeadingEnoughTimeToMarkAsUnusedOvershadowedSegements() {
        long lagNanos;
        long nanosElapsedSinceCoordinatorStart = System.nanoTime() - this.getStartTimeNanos();
        return nanosElapsedSinceCoordinatorStart > (lagNanos = TimeUnit.MILLISECONDS.toNanos(this.coordinatorDynamicConfig.getLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments()));
    }

    public DataSourcesSnapshot getDataSourcesSnapshot() {
        return this.dataSourcesSnapshot;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder buildFromExisting() {
        return new Builder(this.startTimeNanos, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, this.usedSegments, this.dataSourcesSnapshot, this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.coordinatorCompactionConfig, this.stats, this.balancerReferenceTimestamp, this.balancerStrategy);
    }

    public Builder buildFromExistingWithoutSegmentsMetadata() {
        return new Builder(this.startTimeNanos, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, null, null, this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.coordinatorCompactionConfig, this.stats, this.balancerReferenceTimestamp, this.balancerStrategy);
    }

    public static class Builder {
        @Nullable
        private Long startTimeNanos;
        private DruidCluster druidCluster;
        private MetadataRuleManager databaseRuleManager;
        private SegmentReplicantLookup segmentReplicantLookup;
        @Nullable
        private TreeSet<DataSegment> usedSegments;
        @Nullable
        private DataSourcesSnapshot dataSourcesSnapshot;
        private final Map<String, LoadQueuePeon> loadManagementPeons;
        private ReplicationThrottler replicationManager;
        private ServiceEmitter emitter;
        private CoordinatorDynamicConfig coordinatorDynamicConfig;
        private CoordinatorCompactionConfig coordinatorCompactionConfig;
        private CoordinatorStats stats;
        private DateTime balancerReferenceTimestamp;
        private BalancerStrategy balancerStrategy;

        private Builder() {
            this.startTimeNanos = null;
            this.druidCluster = null;
            this.databaseRuleManager = null;
            this.segmentReplicantLookup = null;
            this.usedSegments = null;
            this.dataSourcesSnapshot = null;
            this.loadManagementPeons = new HashMap<String, LoadQueuePeon>();
            this.replicationManager = null;
            this.emitter = null;
            this.stats = new CoordinatorStats();
            this.coordinatorDynamicConfig = CoordinatorDynamicConfig.builder().build();
            this.coordinatorCompactionConfig = CoordinatorCompactionConfig.empty();
            this.balancerReferenceTimestamp = DateTimes.nowUtc();
        }

        Builder(long startTimeNanos, DruidCluster cluster, MetadataRuleManager databaseRuleManager, SegmentReplicantLookup segmentReplicantLookup, @Nullable TreeSet<DataSegment> usedSegments, @Nullable DataSourcesSnapshot dataSourcesSnapshot, Map<String, LoadQueuePeon> loadManagementPeons, ReplicationThrottler replicationManager, ServiceEmitter emitter, CoordinatorDynamicConfig coordinatorDynamicConfig, CoordinatorCompactionConfig coordinatorCompactionConfig, CoordinatorStats stats, DateTime balancerReferenceTimestamp, BalancerStrategy balancerStrategy) {
            this.startTimeNanos = startTimeNanos;
            this.druidCluster = cluster;
            this.databaseRuleManager = databaseRuleManager;
            this.segmentReplicantLookup = segmentReplicantLookup;
            this.usedSegments = usedSegments;
            this.dataSourcesSnapshot = dataSourcesSnapshot;
            this.loadManagementPeons = loadManagementPeons;
            this.replicationManager = replicationManager;
            this.emitter = emitter;
            this.coordinatorDynamicConfig = coordinatorDynamicConfig;
            this.coordinatorCompactionConfig = coordinatorCompactionConfig;
            this.stats = stats;
            this.balancerReferenceTimestamp = balancerReferenceTimestamp;
            this.balancerStrategy = balancerStrategy;
        }

        public DruidCoordinatorRuntimeParams build() {
            Preconditions.checkNotNull((Object)this.startTimeNanos, (Object)"startTime must be set");
            return new DruidCoordinatorRuntimeParams(this.startTimeNanos, this.druidCluster, this.databaseRuleManager, this.segmentReplicantLookup, this.usedSegments, this.dataSourcesSnapshot, this.loadManagementPeons, this.replicationManager, this.emitter, this.coordinatorDynamicConfig, this.coordinatorCompactionConfig, this.stats, this.balancerReferenceTimestamp, this.balancerStrategy);
        }

        public Builder withStartTimeNanos(long startTimeNanos) {
            this.startTimeNanos = startTimeNanos;
            return this;
        }

        public Builder withDruidCluster(DruidCluster cluster) {
            this.druidCluster = cluster;
            return this;
        }

        public Builder withDatabaseRuleManager(MetadataRuleManager databaseRuleManager) {
            this.databaseRuleManager = databaseRuleManager;
            return this;
        }

        public Builder withSegmentReplicantLookup(SegmentReplicantLookup lookup) {
            this.segmentReplicantLookup = lookup;
            return this;
        }

        public Builder withSnapshotOfDataSourcesWithAllUsedSegments(DataSourcesSnapshot snapshot) {
            this.usedSegments = DruidCoordinatorRuntimeParams.createUsedSegmentsSet(snapshot.iterateAllUsedSegmentsInSnapshot());
            this.dataSourcesSnapshot = snapshot;
            return this;
        }

        @VisibleForTesting
        public Builder withUsedSegmentsInTest(DataSegment ... usedSegments) {
            return this.withUsedSegmentsInTest(Arrays.asList(usedSegments));
        }

        @VisibleForTesting
        public Builder withUsedSegmentsInTest(Collection<DataSegment> usedSegments) {
            this.usedSegments = DruidCoordinatorRuntimeParams.createUsedSegmentsSet(usedSegments);
            this.dataSourcesSnapshot = DataSourcesSnapshot.fromUsedSegments(usedSegments, (ImmutableMap<String, String>)ImmutableMap.of());
            return this;
        }

        @VisibleForTesting
        public Builder withUsedSegmentsTimelinesPerDataSourceInTest(Map<String, VersionedIntervalTimeline<String, DataSegment>> usedSegmentsTimelinesPerDataSource) {
            this.dataSourcesSnapshot = DataSourcesSnapshot.fromUsedSegmentsTimelines(usedSegmentsTimelinesPerDataSource, (ImmutableMap<String, String>)ImmutableMap.of());
            this.usedSegments = DruidCoordinatorRuntimeParams.createUsedSegmentsSet(this.dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot());
            return this;
        }

        public Builder withLoadManagementPeons(Map<String, LoadQueuePeon> loadManagementPeonsCollection) {
            this.loadManagementPeons.putAll(loadManagementPeonsCollection);
            return this;
        }

        public Builder withReplicationManager(ReplicationThrottler replicationManager) {
            this.replicationManager = replicationManager;
            return this;
        }

        public Builder withEmitter(ServiceEmitter emitter) {
            this.emitter = emitter;
            return this;
        }

        public Builder withCoordinatorStats(CoordinatorStats stats) {
            this.stats.accumulate(stats);
            return this;
        }

        public Builder withDynamicConfigs(CoordinatorDynamicConfig configs) {
            this.coordinatorDynamicConfig = configs;
            return this;
        }

        public Builder withCompactionConfig(CoordinatorCompactionConfig config) {
            this.coordinatorCompactionConfig = config;
            return this;
        }

        public Builder withBalancerReferenceTimestamp(DateTime balancerReferenceTimestamp) {
            this.balancerReferenceTimestamp = balancerReferenceTimestamp;
            return this;
        }

        public Builder withBalancerStrategy(BalancerStrategy balancerStrategy) {
            this.balancerStrategy = balancerStrategy;
            return this;
        }
    }
}

