/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.FastMath;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.ReservoirSegmentSampler;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class CostBalancerStrategy
implements BalancerStrategy {
    private static final EmittingLogger log = new EmittingLogger(CostBalancerStrategy.class);
    private static final double HALF_LIFE = 24.0;
    static final double LAMBDA = Math.log(2.0) / 24.0;
    static final double INV_LAMBDA_SQUARE = 1.0 / (LAMBDA * LAMBDA);
    private static final double MILLIS_IN_HOUR = 3600000.0;
    private static final double MILLIS_FACTOR = 3600000.0 / LAMBDA;
    private final ListeningExecutorService exec;

    public static double computeJointSegmentsCost(DataSegment segmentA, DataSegment segmentB) {
        Interval intervalA = segmentA.getInterval();
        Interval intervalB = segmentB.getInterval();
        double t0 = intervalA.getStartMillis();
        double t1 = ((double)intervalA.getEndMillis() - t0) / MILLIS_FACTOR;
        double start = ((double)intervalB.getStartMillis() - t0) / MILLIS_FACTOR;
        double end = ((double)intervalB.getEndMillis() - t0) / MILLIS_FACTOR;
        double multiplier = segmentA.getDataSource().equals(segmentB.getDataSource()) ? 2.0 : 1.0;
        return INV_LAMBDA_SQUARE * CostBalancerStrategy.intervalCost(t1, start, end) * multiplier;
    }

    public static double intervalCost(double x1, double y0, double y1) {
        if (x1 == 0.0 || y1 == y0) {
            return 0.0;
        }
        if (y0 < 0.0) {
            double tmp = x1;
            x1 = y1 - y0;
            y1 = tmp - y0;
            y0 = -y0;
        }
        if (y0 < x1) {
            double gamma;
            double beta;
            if (y1 <= x1) {
                beta = y1 - y0;
                gamma = x1 - y0;
            } else {
                beta = x1 - y0;
                gamma = y1 - y0;
            }
            return CostBalancerStrategy.intervalCost(y0, y0, y1) + CostBalancerStrategy.intervalCost(beta, beta, gamma) + 2.0 * (beta + FastMath.exp((double)(-beta)) - 1.0);
        }
        double exy0 = FastMath.exp((double)(x1 - y0));
        double exy1 = FastMath.exp((double)(x1 - y1));
        double ey0 = FastMath.exp((double)(0.0 - y0));
        double ey1 = FastMath.exp((double)(0.0 - y1));
        return ey1 - ey0 - (exy1 - exy0);
    }

    public CostBalancerStrategy(ListeningExecutorService exec) {
        this.exec = exec;
    }

    @Override
    public ServerHolder findNewSegmentHomeReplicator(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
        ServerHolder holder = (ServerHolder)this.chooseBestServer((DataSegment)proposalSegment, serverHolders, (boolean)false).rhs;
        if (holder != null && !holder.isServingSegment(proposalSegment)) {
            return holder;
        }
        return null;
    }

    @Override
    public ServerHolder findNewSegmentHomeBalancer(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
        return (ServerHolder)this.chooseBestServer((DataSegment)proposalSegment, serverHolders, (boolean)true).rhs;
    }

    static double computeJointSegmentsCost(DataSegment segment, Iterable<DataSegment> segmentSet) {
        double totalCost = 0.0;
        for (DataSegment s : segmentSet) {
            totalCost += CostBalancerStrategy.computeJointSegmentsCost(segment, s);
        }
        return totalCost;
    }

    @Override
    public BalancerSegmentHolder pickSegmentToMove(List<ServerHolder> serverHolders) {
        return ReservoirSegmentSampler.getRandomBalancerSegmentHolder(serverHolders);
    }

    @Override
    public Iterator<ServerHolder> pickServersToDrop(DataSegment toDrop, NavigableSet<ServerHolder> serverHolders) {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (ServerHolder server : serverHolders) {
            futures.add(this.exec.submit(() -> Pair.of((Object)this.computeCost(toDrop, server, true), (Object)server)));
        }
        ListenableFuture resultsFuture = Futures.allAsList(futures);
        try {
            List results = (List)resultsFuture.get();
            return results.stream().sorted(Comparator.comparingDouble(o -> (Double)o.lhs).reversed()).map(x -> (ServerHolder)x.rhs).collect(Collectors.toList()).iterator();
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "Cost Balancer Multithread strategy wasn't able to complete cost computation.", new Object[0]).emit();
            return Collections.emptyIterator();
        }
    }

    public double calculateInitialTotalCost(List<ServerHolder> serverHolders) {
        double cost = 0.0;
        for (ServerHolder server : serverHolders) {
            DataSegment[] segments;
            for (DataSegment s1 : segments = server.getServer().iterateAllSegments().toArray(new DataSegment[0])) {
                for (DataSegment s2 : segments) {
                    cost += CostBalancerStrategy.computeJointSegmentsCost(s1, s2);
                }
            }
        }
        return cost;
    }

    public double calculateNormalization(List<ServerHolder> serverHolders) {
        double cost = 0.0;
        for (ServerHolder server : serverHolders) {
            for (DataSegment segment : server.getServer().iterateAllSegments()) {
                cost += CostBalancerStrategy.computeJointSegmentsCost(segment, segment);
            }
        }
        return cost;
    }

    @Override
    public void emitStats(String tier, CoordinatorStats stats, List<ServerHolder> serverHolderList) {
        double initialTotalCost = this.calculateInitialTotalCost(serverHolderList);
        double normalization = this.calculateNormalization(serverHolderList);
        double normalizedInitialCost = initialTotalCost / normalization;
        stats.addToTieredStat("initialCost", tier, (long)initialTotalCost);
        stats.addToTieredStat("normalization", tier, (long)normalization);
        stats.addToTieredStat("normalizedInitialCostTimesOneThousand", tier, (long)(normalizedInitialCost * 1000.0));
        log.info("[%s]: Initial Total Cost: [%f], Normalization: [%f], Initial Normalized Cost: [%f]", new Object[]{tier, initialTotalCost, normalization, normalizedInitialCost});
    }

    protected double computeCost(DataSegment proposalSegment, ServerHolder server, boolean includeCurrentServer) {
        long proposalSegmentSize = proposalSegment.getSize();
        if (!includeCurrentServer && server.isServingSegment(proposalSegment)) {
            return Double.POSITIVE_INFINITY;
        }
        if (proposalSegmentSize > server.getAvailableSize() || server.isLoadingSegment(proposalSegment)) {
            return Double.POSITIVE_INFINITY;
        }
        double cost = 0.0;
        cost += CostBalancerStrategy.computeJointSegmentsCost(proposalSegment, Iterables.filter(server.getServer().iterateAllSegments(), segment -> !proposalSegment.equals(segment)));
        cost += CostBalancerStrategy.computeJointSegmentsCost(proposalSegment, server.getPeon().getSegmentsToLoad());
        return cost -= CostBalancerStrategy.computeJointSegmentsCost(proposalSegment, server.getPeon().getSegmentsMarkedToDrop());
    }

    protected Pair<Double, ServerHolder> chooseBestServer(DataSegment proposalSegment, Iterable<ServerHolder> serverHolders, boolean includeCurrentServer) {
        Pair bestServer = Pair.of((Object)Double.POSITIVE_INFINITY, null);
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        for (ServerHolder server : serverHolders) {
            futures.add(this.exec.submit(() -> Pair.of((Object)this.computeCost(proposalSegment, server, includeCurrentServer), (Object)server)));
        }
        ListenableFuture resultsFuture = Futures.allAsList(futures);
        ArrayList<Pair> bestServers = new ArrayList<Pair>();
        bestServers.add(bestServer);
        try {
            for (Pair server : (List)resultsFuture.get()) {
                if (!((Double)server.lhs <= (Double)((Pair)bestServers.get((int)0)).lhs)) continue;
                if ((Double)server.lhs < (Double)((Pair)bestServers.get((int)0)).lhs) {
                    bestServers.clear();
                }
                bestServers.add(server);
            }
            bestServer = (Pair)bestServers.get(ThreadLocalRandom.current().nextInt(bestServers.size()));
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "Cost Balancer Multithread strategy wasn't able to complete cost computation.", new Object[0]).emit();
        }
        return bestServer;
    }
}

