/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.FluentQueryRunnerBuilder;
import org.apache.druid.query.PostProcessingOperator;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.ResultLevelCachingQueryRunner;
import org.apache.druid.query.RetryQueryRunner;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.initialization.ServerConfig;
import org.joda.time.Interval;

public class ClientQuerySegmentWalker
implements QuerySegmentWalker {
    private final ServiceEmitter emitter;
    private final CachingClusteredClient baseClient;
    private final QueryToolChestWarehouse warehouse;
    private final RetryQueryRunnerConfig retryConfig;
    private final ObjectMapper objectMapper;
    private final ServerConfig serverConfig;
    private final Cache cache;
    private final CacheConfig cacheConfig;

    @Inject
    public ClientQuerySegmentWalker(ServiceEmitter emitter, CachingClusteredClient baseClient, QueryToolChestWarehouse warehouse, RetryQueryRunnerConfig retryConfig, ObjectMapper objectMapper, ServerConfig serverConfig, Cache cache, CacheConfig cacheConfig) {
        this.emitter = emitter;
        this.baseClient = baseClient;
        this.warehouse = warehouse;
        this.retryConfig = retryConfig;
        this.objectMapper = objectMapper;
        this.serverConfig = serverConfig;
        this.cache = cache;
        this.cacheConfig = cacheConfig;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.makeRunner(query, this.baseClient.getQueryRunnerForIntervals(query, intervals));
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.makeRunner(query, this.baseClient.getQueryRunnerForSegments(query, specs));
    }

    private <T> QueryRunner<T> makeRunner(Query<T> query, QueryRunner<T> baseClientRunner) {
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        return new ResultLevelCachingQueryRunner<T>(this.makeRunner(query, baseClientRunner, toolChest), toolChest, query, this.objectMapper, this.cache, this.cacheConfig);
    }

    private <T> QueryRunner<T> makeRunner(Query<T> query, QueryRunner<T> baseClientRunner, QueryToolChest<T, Query<T>> toolChest) {
        PostProcessingOperator postProcessing = (PostProcessingOperator)this.objectMapper.convertValue(query.getContextValue("postProcessing"), new TypeReference<PostProcessingOperator<T>>(){});
        return new FluentQueryRunnerBuilder(toolChest).create(new SetAndVerifyContextQueryRunner(this.serverConfig, new RetryQueryRunner(baseClientRunner, this.retryConfig, this.objectMapper))).applyPreMergeDecoration().mergeResults().applyPostMergeDecoration().emitCPUTimeMetric(this.emitter).postProcess(postProcessing);
    }
}

