/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.JettyUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.proxy.AsyncProxyServlet;

public class AsyncManagementForwardingServlet
extends AsyncProxyServlet {
    private static final EmittingLogger log = new EmittingLogger(AsyncManagementForwardingServlet.class);
    private static final String BASE_URI_ATTRIBUTE = "org.apache.druid.proxy.to.base.uri";
    private static final String MODIFIED_PATH_ATTRIBUTE = "org.apache.druid.proxy.to.path";
    private static final String STANDARD_COORDINATOR_BASE_PATH = "/druid/coordinator";
    private static final String STANDARD_OVERLORD_BASE_PATH = "/druid/indexer";
    private static final String ARBITRARY_COORDINATOR_BASE_PATH = "/proxy/coordinator";
    private static final String ARBITRARY_OVERLORD_BASE_PATH = "/proxy/overlord";
    private final ObjectMapper jsonMapper;
    private final Provider<HttpClient> httpClientProvider;
    private final DruidHttpClientConfig httpClientConfig;
    private final DruidLeaderSelector coordLeaderSelector;
    private final DruidLeaderSelector overlordLeaderSelector;

    @Inject
    public AsyncManagementForwardingServlet(@Json ObjectMapper jsonMapper, @Global Provider<HttpClient> httpClientProvider, @Global DruidHttpClientConfig httpClientConfig, @Coordinator DruidLeaderSelector coordLeaderSelector, @IndexingService DruidLeaderSelector overlordLeaderSelector) {
        this.jsonMapper = jsonMapper;
        this.httpClientProvider = httpClientProvider;
        this.httpClientConfig = httpClientConfig;
        this.coordLeaderSelector = coordLeaderSelector;
        this.overlordLeaderSelector = overlordLeaderSelector;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String currentLeader;
        String requestURI = StringUtils.toLowerCase((String)request.getRequestURI());
        if (requestURI.startsWith(STANDARD_COORDINATOR_BASE_PATH)) {
            currentLeader = this.coordLeaderSelector.getCurrentLeader();
        } else if (requestURI.startsWith(STANDARD_OVERLORD_BASE_PATH)) {
            currentLeader = this.overlordLeaderSelector.getCurrentLeader();
        } else if (requestURI.startsWith(ARBITRARY_COORDINATOR_BASE_PATH)) {
            currentLeader = this.coordLeaderSelector.getCurrentLeader();
            request.setAttribute(MODIFIED_PATH_ATTRIBUTE, (Object)request.getRequestURI().substring(ARBITRARY_COORDINATOR_BASE_PATH.length()));
        } else if (requestURI.startsWith(ARBITRARY_OVERLORD_BASE_PATH)) {
            currentLeader = this.overlordLeaderSelector.getCurrentLeader();
            request.setAttribute(MODIFIED_PATH_ATTRIBUTE, (Object)request.getRequestURI().substring(ARBITRARY_OVERLORD_BASE_PATH.length()));
        } else {
            this.handleBadRequest(response, StringUtils.format((String)"Unsupported proxy destination [%s]", (Object[])new Object[]{request.getRequestURI()}));
            return;
        }
        if (currentLeader == null) {
            this.handleBadRequest(response, StringUtils.format((String)"Unable to determine destination for [%s]; is your coordinator/overlord running?", (Object[])new Object[]{request.getRequestURI()}));
            return;
        }
        request.setAttribute(BASE_URI_ATTRIBUTE, (Object)currentLeader);
        super.service(request, response);
    }

    protected void sendProxyRequest(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) {
        proxyRequest.timeout(this.httpClientConfig.getReadTimeout().getMillis(), TimeUnit.MILLISECONDS);
        proxyRequest.idleTimeout(this.httpClientConfig.getReadTimeout().getMillis(), TimeUnit.MILLISECONDS);
        clientRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        super.sendProxyRequest(clientRequest, proxyResponse, proxyRequest);
    }

    protected String rewriteTarget(HttpServletRequest request) {
        String encodedPath = request.getAttribute(MODIFIED_PATH_ATTRIBUTE) != null ? (String)request.getAttribute(MODIFIED_PATH_ATTRIBUTE) : request.getRequestURI();
        return JettyUtils.concatenateForRewrite((String)request.getAttribute(BASE_URI_ATTRIBUTE), encodedPath, request.getQueryString());
    }

    protected HttpClient newHttpClient() {
        return (HttpClient)this.httpClientProvider.get();
    }

    protected HttpClient createHttpClient() throws ServletException {
        HttpClient client = super.createHttpClient();
        this.setTimeout(this.httpClientConfig.getReadTimeout().getMillis());
        return client;
    }

    private void handleBadRequest(HttpServletResponse response, String errorMessage) throws IOException {
        if (!response.isCommitted()) {
            response.resetBuffer();
            response.setStatus(400);
            this.jsonMapper.writeValue((OutputStream)response.getOutputStream(), (Object)ImmutableMap.of((Object)"error", (Object)errorMessage));
        }
        response.flushBuffer();
    }
}

