/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.prefetch.CacheManager;
import org.apache.druid.data.input.impl.prefetch.FetchConfig;
import org.apache.druid.data.input.impl.prefetch.JsonIterator;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.data.input.impl.prefetch.OpenObject;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.realtime.firehose.SqlFetcher;
import org.apache.druid.segment.realtime.firehose.SqlFirehose;

public abstract class PrefetchSqlFirehoseFactory<T>
implements FirehoseFactory<InputRowParser<Map<String, Object>>> {
    private static final Logger LOG = new Logger(PrefetchSqlFirehoseFactory.class);
    private final FetchConfig fetchConfig;
    private final CacheManager<T> cacheManager;
    private List<T> objects;
    private ObjectMapper objectMapper;

    public PrefetchSqlFirehoseFactory(Long maxCacheCapacityBytes, Long maxFetchCapacityBytes, Long prefetchTriggerBytes, Long fetchTimeout, ObjectMapper objectMapper) {
        this.fetchConfig = new FetchConfig(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, Integer.valueOf(0));
        this.cacheManager = new CacheManager(this.fetchConfig.getMaxCacheCapacityBytes());
        this.objectMapper = objectMapper;
    }

    @JsonProperty
    public long getMaxCacheCapacityBytes() {
        return this.cacheManager.getMaxCacheCapacityBytes();
    }

    @JsonProperty
    public long getMaxFetchCapacityBytes() {
        return this.fetchConfig.getMaxFetchCapacityBytes();
    }

    @JsonProperty
    public long getPrefetchTriggerBytes() {
        return this.fetchConfig.getPrefetchTriggerBytes();
    }

    @JsonProperty
    public long getFetchTimeout() {
        return this.fetchConfig.getFetchTimeout();
    }

    public Firehose connect(InputRowParser<Map<String, Object>> firehoseParser, final @Nullable File temporaryDirectory) {
        if (this.objects == null) {
            this.objects = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(this.initObjects(), (Object)"objects")));
        }
        if (this.cacheManager.isEnabled() || this.fetchConfig.getMaxFetchCapacityBytes() > 0L) {
            Preconditions.checkNotNull((Object)temporaryDirectory, (Object)"temporaryDirectory");
            Preconditions.checkArgument((boolean)temporaryDirectory.exists(), (String)"temporaryDirectory[%s] does not exist", (Object[])new Object[]{temporaryDirectory});
            Preconditions.checkArgument((boolean)temporaryDirectory.isDirectory(), (String)"temporaryDirectory[%s] is not a directory", (Object[])new Object[]{temporaryDirectory});
        }
        LOG.info("Create a new firehose for [%d] queries", new Object[]{this.objects.size()});
        ExecutorService fetchExecutor = Execs.singleThreaded((String)"firehose_fetch_%d");
        final SqlFetcher<T> fetcher = new SqlFetcher<T>(this.cacheManager, this.objects, fetchExecutor, temporaryDirectory, this.fetchConfig, new ObjectOpenFunction<T>(){

            public InputStream open(T object, File outFile) throws IOException {
                return PrefetchSqlFirehoseFactory.this.openObjectStream(object, outFile);
            }

            public InputStream open(T object) throws IOException {
                File outFile = File.createTempFile("sqlresults_", null, temporaryDirectory);
                return PrefetchSqlFirehoseFactory.this.openObjectStream(object, outFile);
            }
        });
        return new SqlFirehose(new Iterator<JsonIterator<Map<String, Object>>>(){

            @Override
            public boolean hasNext() {
                return fetcher.hasNext();
            }

            @Override
            public JsonIterator<Map<String, Object>> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    TypeReference<Map<String, Object>> type = new TypeReference<Map<String, Object>>(){};
                    OpenObject openObject = fetcher.next();
                    InputStream stream = openObject.getObjectStream();
                    return new JsonIterator((TypeReference)type, stream, openObject.getResourceCloser(), PrefetchSqlFirehoseFactory.this.objectMapper);
                }
                catch (Exception ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }, firehoseParser, () -> {
            fetchExecutor.shutdownNow();
            try {
                Preconditions.checkState((boolean)fetchExecutor.awaitTermination(this.fetchConfig.getFetchTimeout(), TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ISE("Failed to shutdown fetch executor during close", new Object[0]);
            }
        });
    }

    protected abstract InputStream openObjectStream(T var1, File var2) throws IOException;

    protected abstract Collection<T> initObjects();
}

