/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;

public class Committed {
    private static final Committed NIL = new Committed((Map<String, Integer>)ImmutableMap.of(), null);
    private final ImmutableMap<String, Integer> hydrants;
    private final Object metadata;

    @JsonCreator
    public Committed(@JsonProperty(value="hydrants") Map<String, Integer> hydrants, @JsonProperty(value="metadata") Object metadata) {
        this.hydrants = ImmutableMap.copyOf(hydrants);
        this.metadata = metadata;
    }

    public static Committed create(Map<SegmentIdWithShardSpec, Integer> hydrants0, Object metadata) {
        ImmutableMap.Builder hydrants = ImmutableMap.builder();
        for (Map.Entry<SegmentIdWithShardSpec, Integer> entry : hydrants0.entrySet()) {
            hydrants.put((Object)entry.getKey().toString(), (Object)entry.getValue());
        }
        return new Committed((Map<String, Integer>)hydrants.build(), metadata);
    }

    @JsonProperty
    public ImmutableMap<String, Integer> getHydrants() {
        return this.hydrants;
    }

    @JsonProperty
    public Object getMetadata() {
        return this.metadata;
    }

    public int getCommittedHydrants(String identifierAsString) {
        Integer committedHydrant = (Integer)this.hydrants.get((Object)identifierAsString);
        return committedHydrant == null ? 0 : committedHydrant;
    }

    public Committed without(String identifierAsString) {
        HashMap<String, Integer> newHydrants = new HashMap<String, Integer>();
        newHydrants.putAll((Map<String, Integer>)this.hydrants);
        newHydrants.remove(identifierAsString);
        return new Committed(newHydrants, this.metadata);
    }

    public Committed with(Map<String, Integer> hydrantsToAdd) {
        HashMap<String, Integer> newHydrants = new HashMap<String, Integer>();
        newHydrants.putAll((Map<String, Integer>)this.hydrants);
        newHydrants.putAll(hydrantsToAdd);
        return new Committed(newHydrants, this.metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Committed committed = (Committed)o;
        return Objects.equals(this.hydrants, committed.hydrants) && Objects.equals(this.metadata, committed.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.hydrants, this.metadata);
    }

    public String toString() {
        return "Committed{hydrants=" + this.hydrants + ", metadata=" + this.metadata + '}';
    }

    public static Committed nil() {
        return NIL;
    }
}

