/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class FireHydrant {
    private final int count;
    private final AtomicReference<ReferenceCountingSegment> adapter;
    private volatile IncrementalIndex index;

    public FireHydrant(IncrementalIndex index, int count, SegmentId segmentId) {
        this.index = index;
        this.adapter = new AtomicReference<ReferenceCountingSegment>(ReferenceCountingSegment.wrapRootGenerationSegment((Segment)new IncrementalIndexSegment(index, segmentId)));
        this.count = count;
    }

    public FireHydrant(Segment adapter, int count) {
        this.index = null;
        this.adapter = new AtomicReference<ReferenceCountingSegment>(ReferenceCountingSegment.wrapRootGenerationSegment((Segment)adapter));
        this.count = count;
    }

    public IncrementalIndex getIndex() {
        return this.index;
    }

    public SegmentId getSegmentId() {
        return this.adapter.get().getId();
    }

    public Interval getSegmentDataInterval() {
        return this.adapter.get().getDataInterval();
    }

    public ReferenceCountingSegment getIncrementedSegment() {
        ReferenceCountingSegment segment = this.adapter.get();
        while (!segment.increment()) {
            ReferenceCountingSegment newSegment = this.adapter.get();
            if (segment == newSegment) {
                throw new ISE("segment.close() is called somewhere outside FireHydrant.swapSegment()", new Object[0]);
            }
            if (newSegment == null) {
                throw new ISE("FireHydrant was 'closed' by swapping segment to null while acquiring a segment", new Object[0]);
            }
            segment = newSegment;
        }
        return segment;
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasSwapped() {
        return this.index == null;
    }

    public void swapSegment(@Nullable Segment newSegment) {
        ReferenceCountingSegment newReferenceCountingSegment;
        ReferenceCountingSegment currentSegment;
        do {
            if ((currentSegment = this.adapter.get()) == null && newSegment == null) {
                return;
            }
            if (currentSegment != null && newSegment != null && !newSegment.getId().equals((Object)currentSegment.getId())) {
                throw new ISE("WTF?! Cannot swap identifier[%s] -> [%s]!", new Object[]{currentSegment.getId(), newSegment.getId()});
            }
            if (currentSegment != newSegment) continue;
            throw new ISE("Cannot swap to the same segment", new Object[0]);
        } while (!this.adapter.compareAndSet(currentSegment, newReferenceCountingSegment = newSegment != null ? ReferenceCountingSegment.wrapRootGenerationSegment((Segment)newSegment) : null));
        if (currentSegment != null) {
            currentSegment.close();
        }
        this.index = null;
    }

    public Pair<Segment, Closeable> getAndIncrementSegment() {
        ReferenceCountingSegment segment = this.getIncrementedSegment();
        return new Pair((Object)segment, (Object)segment.decrementOnceCloseable());
    }

    public String toString() {
        return "FireHydrant{queryable=" + this.adapter.get().getId() + ", count=" + this.count + '}';
    }
}

