/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.io.IOException;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;

@ManageLifecycle
public class CliIndexerDataSegmentServerAnnouncerLifecycleHandler {
    private static final EmittingLogger LOG = new EmittingLogger(CliIndexerDataSegmentServerAnnouncerLifecycleHandler.class);
    private final DataSegmentServerAnnouncer dataSegmentServerAnnouncer;
    private final LifecycleLock lifecycleLock = new LifecycleLock();

    @Inject
    public CliIndexerDataSegmentServerAnnouncerLifecycleHandler(DataSegmentServerAnnouncer dataSegmentServerAnnouncer) {
        this.dataSegmentServerAnnouncer = dataSegmentServerAnnouncer;
    }

    @LifecycleStart
    public void start() throws IOException {
        if (!this.lifecycleLock.canStart()) {
            throw new RuntimeException("Lifecycle lock could not start");
        }
        try {
            if (this.lifecycleLock.isStarted()) {
                return;
            }
            LOG.info("Starting...", new Object[0]);
            try {
                this.dataSegmentServerAnnouncer.announce();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, IOException.class);
                throw new RuntimeException(e);
            }
            LOG.info("Started.", new Object[0]);
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new RuntimeException("Lifecycle lock could not stop");
        }
        if (!this.lifecycleLock.isStarted()) {
            return;
        }
        LOG.info("Stopping...", new Object[0]);
        try {
            this.dataSegmentServerAnnouncer.unannounce();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.info("Stopped.", new Object[0]);
    }
}

