/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupIntrospectHandler;
import org.apache.druid.server.http.security.ConfigResourceFilter;

@Path(value="/druid/v1/lookups/introspect")
@ResourceFilters(value={ConfigResourceFilter.class})
public class LookupIntrospectionResource {
    private static final Logger LOGGER = new Logger(LookupIntrospectionResource.class);
    private final LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider;

    @Inject
    public LookupIntrospectionResource(@Context LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider) {
        this.lookupExtractorFactoryContainerProvider = lookupExtractorFactoryContainerProvider;
    }

    @Path(value="/{lookupId}")
    public Object introspectLookup(@PathParam(value="lookupId") String lookupId) {
        LookupExtractorFactoryContainer container = this.lookupExtractorFactoryContainerProvider.get(lookupId);
        if (container == null) {
            LOGGER.error("trying to introspect non existing lookup [%s]", new Object[]{lookupId});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LookupIntrospectHandler introspectHandler = container.getLookupExtractorFactory().getIntrospectHandler();
        if (introspectHandler != null) {
            return introspectHandler;
        }
        LOGGER.warn("Trying to introspect lookup [%s] of type [%s] but implementation doesn't provide resource", new Object[]{lookupId, ((LookupExtractor)container.getLookupExtractorFactory().get()).getClass()});
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

