/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DummyBlockingPool;
import org.apache.druid.collections.DummyNonBlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.guice.annotations.Processing;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ExecutorServiceConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.ExecutorServiceMonitor;
import org.apache.druid.server.metrics.MetricsModule;

public class RouterProcessingModule
implements Module {
    private static final Logger log = new Logger(RouterProcessingModule.class);

    public void configure(Binder binder) {
        binder.bind(ExecutorServiceConfig.class).to(DruidProcessingConfig.class);
        MetricsModule.register(binder, ExecutorServiceMonitor.class);
    }

    @Provides
    @Processing
    @ManageLifecycle
    public ExecutorService getProcessingExecutorService(DruidProcessingConfig config) {
        if (config.getNumThreadsConfigured() != -1) {
            log.error("numThreads[%d] configured, that is ignored on Router", new Object[]{config.getNumThreadsConfigured()});
        }
        return Execs.dummy();
    }

    @Provides
    @LazySingleton
    @Global
    public NonBlockingPool<ByteBuffer> getIntermediateResultsPool() {
        return DummyNonBlockingPool.instance();
    }

    @Provides
    @LazySingleton
    @Merging
    public BlockingPool<ByteBuffer> getMergeBufferPool(DruidProcessingConfig config) {
        if (config.getNumMergeBuffersConfigured() != -1) {
            log.error("numMergeBuffers[%d] configured, that is ignored on Router", new Object[]{config.getNumMergeBuffersConfigured()});
        }
        return DummyBlockingPool.instance();
    }
}

