/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.client.indexing.ClientCompactQueryTuningConfig;
import org.apache.druid.client.indexing.ClientCompactionIOConfig;
import org.apache.druid.client.indexing.ClientQuery;

public class ClientCompactQuery
implements ClientQuery {
    private final String dataSource;
    private final ClientCompactionIOConfig ioConfig;
    private final ClientCompactQueryTuningConfig tuningConfig;
    private final Map<String, Object> context;

    @JsonCreator
    public ClientCompactQuery(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="ioConfig") ClientCompactionIOConfig ioConfig, @JsonProperty(value="tuningConfig") ClientCompactQueryTuningConfig tuningConfig, @JsonProperty(value="context") Map<String, Object> context) {
        this.dataSource = dataSource;
        this.ioConfig = ioConfig;
        this.tuningConfig = tuningConfig;
        this.context = context;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "compact";
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public ClientCompactionIOConfig getIoConfig() {
        return this.ioConfig;
    }

    @JsonProperty
    public ClientCompactQueryTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactQuery that = (ClientCompactQuery)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.ioConfig, that.ioConfig) && Objects.equals(this.tuningConfig, that.tuningConfig) && Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.ioConfig, this.tuningConfig, this.context);
    }

    public String toString() {
        return "ClientCompactQuery{dataSource='" + this.dataSource + '\'' + ", ioConfig=" + this.ioConfig + ", tuningConfig=" + this.tuningConfig + ", context=" + this.context + '}';
    }
}

