/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;

public class ResultLevelCacheUtil {
    private static final Logger log = new Logger(ResultLevelCacheUtil.class);

    public static Cache.NamedKey computeResultLevelCacheKey(String resultLevelCacheIdentifier) {
        return new Cache.NamedKey(resultLevelCacheIdentifier, StringUtils.toUtf8((String)resultLevelCacheIdentifier));
    }

    public static void populate(Cache cache, Cache.NamedKey key, byte[] resultBytes) {
        log.debug("Populating results into cache", new Object[0]);
        cache.put(key, resultBytes);
    }

    public static <T> boolean useResultLevelCacheOnBrokers(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, CacheConfig cacheConfig) {
        return ResultLevelCacheUtil.useResultLevelCache(query, strategy, cacheConfig) && strategy.isCacheable(query, false);
    }

    public static <T> boolean populateResultLevelCacheOnBrokers(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, CacheConfig cacheConfig) {
        return ResultLevelCacheUtil.populateResultLevelCache(query, strategy, cacheConfig) && strategy.isCacheable(query, false);
    }

    private static <T> boolean useResultLevelCache(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, CacheConfig cacheConfig) {
        return QueryContexts.isUseResultLevelCache(query) && strategy != null && cacheConfig.isUseResultLevelCache() && cacheConfig.isQueryCacheable(query);
    }

    private static <T> boolean populateResultLevelCache(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, CacheConfig cacheConfig) {
        return QueryContexts.isPopulateResultLevelCache(query) && strategy != null && cacheConfig.isPopulateResultLevelCache() && cacheConfig.isQueryCacheable(query);
    }
}

