/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import javax.annotation.Nullable;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.roaringbitmap.PeekableIntIterator;

public class VectorSelectorUtils {
    @Nullable
    public static boolean[] populateNullVector(@Nullable boolean[] nullVector, ReadableVectorOffset offset, PeekableIntIterator nullIterator) {
        if (!nullIterator.hasNext()) {
            return null;
        }
        boolean[] retVal = nullVector != null ? nullVector : new boolean[offset.getMaxVectorSize()];
        if (offset.isContiguous()) {
            int startOffset = offset.getStartOffset();
            nullIterator.advanceIfNeeded(startOffset);
            if (!nullIterator.hasNext()) {
                return null;
            }
            for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                int row = i + startOffset;
                nullIterator.advanceIfNeeded(row);
                if (nullIterator.hasNext()) {
                    retVal[i] = row == nullIterator.peekNext();
                    continue;
                }
                break;
            }
        } else {
            int[] currentOffsets = offset.getOffsets();
            nullIterator.advanceIfNeeded(currentOffsets[0]);
            if (!nullIterator.hasNext()) {
                return null;
            }
            for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                int row = currentOffsets[i];
                nullIterator.advanceIfNeeded(row);
                if (nullIterator.hasNext()) {
                    retVal[i] = row == nullIterator.peekNext();
                    continue;
                }
                break;
            }
        }
        return retVal;
    }
}

