/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.base.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.StringDictionaryEncodedColumn;
import org.apache.druid.segment.data.CachingIndexed;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.GenericIndexed;

public class DictionaryEncodedColumnSupplier
implements Supplier<DictionaryEncodedColumn<?>> {
    private final GenericIndexed<String> dictionary;
    @Nullable
    private final Supplier<ColumnarInts> singleValuedColumn;
    @Nullable
    private final Supplier<ColumnarMultiInts> multiValuedColumn;
    private final int lookupCacheSize;

    public DictionaryEncodedColumnSupplier(GenericIndexed<String> dictionary, @Nullable Supplier<ColumnarInts> singleValuedColumn, @Nullable Supplier<ColumnarMultiInts> multiValuedColumn, int lookupCacheSize) {
        this.dictionary = dictionary;
        this.singleValuedColumn = singleValuedColumn;
        this.multiValuedColumn = multiValuedColumn;
        this.lookupCacheSize = lookupCacheSize;
    }

    public DictionaryEncodedColumn<?> get() {
        return new StringDictionaryEncodedColumn(this.singleValuedColumn != null ? (ColumnarInts)this.singleValuedColumn.get() : null, this.multiValuedColumn != null ? (ColumnarMultiInts)this.multiValuedColumn.get() : null, new CachingIndexed<String>(this.dictionary, this.lookupCacheSize));
    }
}

