/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class ComplexMetrics {
    private static final Map<String, ComplexMetricSerde> COMPLEX_SERIALIZERS = new HashMap<String, ComplexMetricSerde>();

    @Nullable
    public static ComplexMetricSerde getSerdeForType(String type) {
        return COMPLEX_SERIALIZERS.get(type);
    }

    public static void registerSerde(String type, ComplexMetricSerde serde) {
        if (COMPLEX_SERIALIZERS.containsKey(type)) {
            if (!COMPLEX_SERIALIZERS.get(type).getClass().getName().equals(serde.getClass().getName())) {
                throw new ISE("Incompatible serializer for type[%s] already exists. Expected [%s], found [%s].", new Object[]{type, serde.getClass().getName(), COMPLEX_SERIALIZERS.get(type).getClass().getName()});
            }
        } else {
            COMPLEX_SERIALIZERS.put(type, serde);
        }
    }
}

