/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class LongsLongEncodingWriter
implements CompressionFactory.LongEncodingWriter {
    private final ByteBuffer orderBuffer;
    private final ByteOrder order;
    @Nullable
    private ByteBuffer outBuffer = null;
    @Nullable
    private OutputStream outStream = null;

    public LongsLongEncodingWriter(ByteOrder order) {
        this.order = order;
        this.orderBuffer = ByteBuffer.allocate(8);
        this.orderBuffer.order(order);
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.outStream = null;
        this.outBuffer = buffer;
        this.outBuffer.order(this.order);
    }

    @Override
    public void setOutputStream(WriteOutBytes output) {
        this.outBuffer = null;
        this.outStream = output;
    }

    @Override
    public void write(long value) throws IOException {
        if (this.outBuffer != null) {
            this.outBuffer.putLong(value);
        }
        if (this.outStream != null) {
            this.orderBuffer.rewind();
            this.orderBuffer.putLong(value);
            this.outStream.write(this.orderBuffer.array());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void putMeta(ByteBuffer metaOut, CompressionStrategy strategy) {
        metaOut.put(strategy.getId());
    }

    @Override
    public int metaSize() {
        return 1;
    }

    @Override
    public int getBlockSize(int bytesPerBlock) {
        return bytesPerBlock / 8;
    }

    @Override
    public int getNumBytes(int values) {
        return values * 8;
    }
}

