/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.VSizeLongSerde;

public class DeltaLongEncodingReader
implements CompressionFactory.LongEncodingReader {
    private ByteBuffer buffer;
    private final long base;
    private final int bitsPerValue;
    private VSizeLongSerde.LongDeserializer deserializer;

    public DeltaLongEncodingReader(ByteBuffer fromBuffer) {
        this.buffer = fromBuffer.asReadOnlyBuffer();
        byte version = this.buffer.get();
        if (version != 1) {
            throw new IAE("Unknown version[%s]", new Object[]{version});
        }
        this.base = this.buffer.getLong();
        this.bitsPerValue = this.buffer.getInt();
        fromBuffer.position(this.buffer.position());
        this.deserializer = VSizeLongSerde.getDeserializer(this.bitsPerValue, this.buffer, this.buffer.position());
    }

    private DeltaLongEncodingReader(ByteBuffer buffer, long base, int bitsPerValue) {
        this.buffer = buffer;
        this.base = base;
        this.bitsPerValue = bitsPerValue;
        this.deserializer = VSizeLongSerde.getDeserializer(bitsPerValue, buffer, buffer.position());
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.deserializer = VSizeLongSerde.getDeserializer(this.bitsPerValue, buffer, buffer.position());
    }

    @Override
    public long read(int index) {
        return this.base + this.deserializer.get(index);
    }

    @Override
    public CompressionFactory.LongEncodingReader duplicate() {
        return new DeltaLongEncodingReader(this.buffer.duplicate(), this.base, this.bitsPerValue);
    }
}

