/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Comparator;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.FloatDimensionIndexer;
import org.apache.druid.segment.FloatDimensionMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableFloatColumnValueSelector;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class FloatDimensionHandler
implements DimensionHandler<Float, Float, Float> {
    private static Comparator<ColumnValueSelector> FLOAT_COLUMN_COMPARATOR = (s1, s2) -> {
        if (s1.isNull()) {
            return s2.isNull() ? 0 : -1;
        }
        if (s2.isNull()) {
            return 1;
        }
        return Float.compare(s1.getFloat(), s2.getFloat());
    };
    private final String dimensionName;

    public FloatDimensionHandler(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public DimensionIndexer<Float, Float, Float> makeIndexer() {
        return new FloatDimensionIndexer();
    }

    @Override
    public DimensionMergerV9 makeMerger(IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress, Closer closer) {
        return new FloatDimensionMergerV9(this.dimensionName, indexSpec, segmentWriteOutMedium);
    }

    @Override
    public int getLengthOfEncodedKeyComponent(Float dimVals) {
        return 1;
    }

    @Override
    public Comparator<ColumnValueSelector> getEncodedValueSelectorComparator() {
        return FLOAT_COLUMN_COMPARATOR;
    }

    @Override
    public SettableColumnValueSelector makeNewSettableEncodedValueSelector() {
        return new SettableFloatColumnValueSelector();
    }
}

