/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.IndexedIterable;

public class ColumnSelectorBitmapIndexSelector
implements BitmapIndexSelector {
    private final BitmapFactory bitmapFactory;
    private final VirtualColumns virtualColumns;
    private final ColumnSelector index;

    public ColumnSelectorBitmapIndexSelector(BitmapFactory bitmapFactory, VirtualColumns virtualColumns, ColumnSelector index) {
        this.bitmapFactory = bitmapFactory;
        this.virtualColumns = virtualColumns;
        this.index = index;
    }

    @Override
    @Nullable
    public CloseableIndexed<String> getDimensionValues(String dimension) {
        if (this.isVirtualColumn(dimension)) {
            final BitmapIndex bitmapIndex = this.virtualColumns.getBitmapIndex(dimension, this.index);
            if (bitmapIndex == null) {
                return null;
            }
            return new CloseableIndexed<String>(){

                @Override
                public int size() {
                    return bitmapIndex.getCardinality();
                }

                @Override
                public String get(int index) {
                    return bitmapIndex.getValue(index);
                }

                @Override
                public int indexOf(String value) {
                    return bitmapIndex.getIndex(value);
                }

                @Override
                public Iterator<String> iterator() {
                    return IndexedIterable.create(this).iterator();
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("column", bitmapIndex);
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder == null) {
            return null;
        }
        BaseColumn col = columnHolder.getColumn();
        if (!(col instanceof DictionaryEncodedColumn)) {
            return null;
        }
        final DictionaryEncodedColumn column = (DictionaryEncodedColumn)col;
        return new CloseableIndexed<String>(){

            @Override
            public int size() {
                return column.getCardinality();
            }

            @Override
            public String get(int index) {
                return (String)column.lookupName(index);
            }

            @Override
            public int indexOf(String value) {
                return column.lookupId(value);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("column", column);
            }

            @Override
            public void close() throws IOException {
                column.close();
            }
        };
    }

    @Override
    public boolean hasMultipleValues(String dimension) {
        if (this.isVirtualColumn(dimension)) {
            return this.virtualColumns.getVirtualColumn(dimension).capabilities(dimension).hasMultipleValues();
        }
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        return columnHolder != null && columnHolder.getCapabilities().hasMultipleValues();
    }

    @Override
    public int getNumRows() {
        try (NumericColumn column = (NumericColumn)this.index.getColumnHolder("__time").getColumn();){
            int n = column.length();
            return n;
        }
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return this.bitmapFactory;
    }

    @Override
    @Nullable
    public BitmapIndex getBitmapIndex(String dimension) {
        if (this.isVirtualColumn(dimension)) {
            return this.virtualColumns.getBitmapIndex(dimension, this.index);
        }
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder == null || !columnHolder.getCapabilities().isFilterable()) {
            return new BitmapIndex(){

                @Override
                public int getCardinality() {
                    return 1;
                }

                @Override
                @Nullable
                public String getValue(int index) {
                    return null;
                }

                @Override
                public boolean hasNulls() {
                    return true;
                }

                @Override
                public BitmapFactory getBitmapFactory() {
                    return ColumnSelectorBitmapIndexSelector.this.bitmapFactory;
                }

                @Override
                public int getIndex(@Nullable String value) {
                    return NullHandling.isNullOrEquivalent((String)value) ? 0 : -2;
                }

                @Override
                public ImmutableBitmap getBitmap(int idx) {
                    if (idx == 0) {
                        return ColumnSelectorBitmapIndexSelector.this.bitmapFactory.complement(ColumnSelectorBitmapIndexSelector.this.bitmapFactory.makeEmptyImmutableBitmap(), ColumnSelectorBitmapIndexSelector.this.getNumRows());
                    }
                    return ColumnSelectorBitmapIndexSelector.this.bitmapFactory.makeEmptyImmutableBitmap();
                }
            };
        }
        if (columnHolder.getCapabilities().hasBitmapIndexes()) {
            return columnHolder.getBitmapIndex();
        }
        return null;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(String dimension, String value) {
        if (this.isVirtualColumn(dimension)) {
            BitmapIndex idx = this.virtualColumns.getBitmapIndex(dimension, this.index);
            if (idx == null) {
                return null;
            }
            return idx.getBitmap(idx.getIndex(value));
        }
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder == null || !columnHolder.getCapabilities().isFilterable()) {
            if (NullHandling.isNullOrEquivalent((String)value)) {
                return this.bitmapFactory.complement(this.bitmapFactory.makeEmptyImmutableBitmap(), this.getNumRows());
            }
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        if (!columnHolder.getCapabilities().hasBitmapIndexes()) {
            return null;
        }
        BitmapIndex bitmapIndex = columnHolder.getBitmapIndex();
        return bitmapIndex.getBitmap(bitmapIndex.getIndex(value));
    }

    @Override
    public ImmutableRTree getSpatialIndex(String dimension) {
        if (this.isVirtualColumn(dimension)) {
            return ImmutableRTree.empty();
        }
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder == null || !columnHolder.getCapabilities().hasSpatialIndexes()) {
            return ImmutableRTree.empty();
        }
        return columnHolder.getSpatialIndex().getRTree();
    }

    private boolean isVirtualColumn(String columnName) {
        return this.virtualColumns.getVirtualColumn(columnName) != null;
    }
}

