/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;

public abstract class AbstractIndex {
    public abstract List<String> getColumnNames();

    public abstract StorageAdapter toStorageAdapter();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StorageAdapter storageAdapter = this.toStorageAdapter();
        List cursors = storageAdapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null).toList();
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("__time");
        columnNames.addAll(this.getColumnNames());
        for (Cursor cursor : cursors) {
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            List selectors = columnNames.stream().map(columnSelectorFactory::makeColumnValueSelector).collect(Collectors.toList());
            while (!cursor.isDone()) {
                sb.append('[');
                for (int i = 0; i < selectors.size(); ++i) {
                    sb.append((String)columnNames.get(i)).append('=');
                    ColumnValueSelector selector = (ColumnValueSelector)selectors.get(i);
                    Object columnValue = selector.getObject();
                    sb.append(columnValue);
                    sb.append(", ");
                }
                sb.setLength(sb.length() - 2);
                sb.append("]\n");
                cursor.advance();
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

