/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;

public class Groupers {
    private static final AggregateResult DICTIONARY_FULL_ZERO_COUNT = AggregateResult.partial(0, "Not enough dictionary space to execute this query. Try increasing druid.query.groupBy.maxMergingDictionarySize or enable disk spilling by setting druid.query.groupBy.maxOnDiskStorage to a positive number.");
    private static final AggregateResult HASH_TABLE_FULL_ZERO_COUNT = AggregateResult.partial(0, "Not enough aggregation buffer space to execute this query. Try increasing druid.processing.buffer.sizeBytes or enable disk spilling by setting druid.query.groupBy.maxOnDiskStorage to a positive number.");
    private static final int USED_FLAG_MASK = Integer.MAX_VALUE;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;

    private Groupers() {
    }

    private static int smear(int hashCode) {
        return 461845907 * Integer.rotateLeft(hashCode * -862048943, 15);
    }

    public static AggregateResult dictionaryFull(int count) {
        if (count == 0) {
            return DICTIONARY_FULL_ZERO_COUNT;
        }
        return AggregateResult.partial(count, DICTIONARY_FULL_ZERO_COUNT.getReason());
    }

    public static AggregateResult hashTableFull(int count) {
        if (count == 0) {
            return HASH_TABLE_FULL_ZERO_COUNT;
        }
        return AggregateResult.partial(count, HASH_TABLE_FULL_ZERO_COUNT.getReason());
    }

    public static int hashObject(Object obj) {
        return Groupers.smear(obj.hashCode()) & Integer.MAX_VALUE;
    }

    public static int hashIntArray(int[] ints, int start, int length) {
        int hashCode = 1;
        for (int i = 0; i < length; ++i) {
            hashCode = 31 * hashCode + ints[start + i];
        }
        return Groupers.smear(hashCode) & Integer.MAX_VALUE;
    }

    static int getUsedFlag(int keyHash) {
        return keyHash | Integer.MIN_VALUE;
    }

    public static ByteBuffer getSlice(ByteBuffer buffer, int sliceSize, int i) {
        ByteBuffer slice = buffer.duplicate();
        slice.position(sliceSize * i);
        slice.limit(slice.position() + sliceSize);
        return slice.slice();
    }

    @Nullable
    public static int[] writeAggregationRows(int[] scratch, int start, int end) {
        if (start == 0) {
            return null;
        }
        int numRows = end - start;
        for (int i = 0; i < numRows; ++i) {
            scratch[i] = start + i;
        }
        return scratch;
    }
}

