/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import org.apache.druid.query.dimension.VectorColumnStrategizer;
import org.apache.druid.query.filter.vector.DoubleVectorValueMatcher;
import org.apache.druid.query.filter.vector.FloatVectorValueMatcher;
import org.apache.druid.query.filter.vector.LongVectorValueMatcher;
import org.apache.druid.query.filter.vector.MultiValueStringVectorValueMatcher;
import org.apache.druid.query.filter.vector.SingleValueStringVectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class VectorValueMatcherColumnStrategizer
implements VectorColumnStrategizer<VectorValueMatcherFactory> {
    private static final VectorValueMatcherColumnStrategizer INSTANCE = new VectorValueMatcherColumnStrategizer();

    private VectorValueMatcherColumnStrategizer() {
    }

    public static VectorValueMatcherColumnStrategizer instance() {
        return INSTANCE;
    }

    @Override
    public VectorValueMatcherFactory makeSingleValueDimensionStrategy(SingleValueDimensionVectorSelector selector) {
        return new SingleValueStringVectorValueMatcher(selector);
    }

    @Override
    public VectorValueMatcherFactory makeMultiValueDimensionStrategy(MultiValueDimensionVectorSelector selector) {
        return new MultiValueStringVectorValueMatcher(selector);
    }

    @Override
    public VectorValueMatcherFactory makeFloatStrategy(VectorValueSelector selector) {
        return new FloatVectorValueMatcher(selector);
    }

    @Override
    public VectorValueMatcherFactory makeDoubleStrategy(VectorValueSelector selector) {
        return new DoubleVectorValueMatcher(selector);
    }

    @Override
    public VectorValueMatcherFactory makeLongStrategy(VectorValueSelector selector) {
        return new LongVectorValueMatcher(selector);
    }
}

